with Gnat.Os_Lib;
use Gnat.Os_Lib;
with Ada.Wide_Text_Io;
with Ada.Text_Io;
with Ada.Strings.Fixed;
use Ada.Strings.Fixed;
procedure Hello is
   package T_Io renames Ada.Text_Io;
   package W_Io renames Ada.Wide_Text_Io;
   
   ---------------------------------------
   --         For Hello msg             --
   ---------------------------------------
   The_World : constant String := "world";
   The_Msg   : constant String := "Hello";   
   User_Val  : constant String := "USER";
   Lang_Val  : constant String := "LANG";
   
   The_User  : String_Access;
   The_Lang  : String_Access;
   
   type Lang_Enum is (En, Fr, C);
   Lang      : Lang_Enum := En;
   
   Color     : constant String := Character'Val(27) & "[01;36m";
   Normal    : constant String := Character'Val(27) & "[00m";
   
   En_Msg : constant String := "Hello";
   Fr_Msg : constant String := "Salut";
   C_Msg  : constant String := "Error";
   
   
   C_Text  : constant Wide_String := "I come from a standard C";	    
   En_Text : constant Wide_String := "I come from the France !";
   Fr_Text : constant Wide_String := "je suis venu de France !";
   
begin
   The_User := Getenv(User_Val);
   The_Lang := Getenv(Lang_Val);
   if The_Lang /= null then
      begin
	 Lang := Lang_Enum'Value(The_Lang.all(1..2));
      exception
	 when Constraint_Error =>
	    W_Io.Put_Line("Uncknow language ; ");
      end;
   end if;	       
   W_Io.New_Line;
   if The_User /= null then            
      T_Io.Put_Line(((The_User'Length+En_Msg'Length+10) *  '-'));
      case Lang is	 
	 when En =>
	    T_Io.Put_Line("-- " & En_Msg & ' ' & Color & The_User.all & Normal & " ! " & " --");
	 when Fr =>
	    T_Io.Put_Line("-- " & Fr_Msg & ' ' & Color & The_User.all & Normal & " ! " & " --");	   
	 when C =>
	    T_Io.Put_Line("-- " & C_Msg & ' ' & Color & The_User.all & Normal & " ! " & " --");
      end case;      
      T_Io.Put_Line(((The_User'Length+En_Msg'Length+10) *  '-'));
   else      
      T_Io.Put_Line(((The_world'Length+Fr_Msg'Length+10) *  '-'));
      T_Io.Put_Line("-- " & Fr_Msg & ' ' & The_World & " ! " & " --");
      T_Io.Put_Line(((The_world'Length+Fr_Msg'Length+10) *  '-'));
   end if;   
   W_Io.New_Line;
   case Lang is
      when En =>		  		  
	 for Wchar in En_Text'Range loop
	    W_Io.Put(En_Text(Wchar));
	    delay 0.025;
	 end loop;
      when Fr =>
	 W_Io.New_Line;
	 for Wchar in Fr_Text'Range loop
	    W_Io.Put(En_Text(Wchar));
	    delay 0.025;
	 end loop;
      when C =>
	 W_Io.New_Line;
	 for Wchar in C_Text'Range loop
	    W_Io.Put(En_Text(Wchar));
	    delay 0.025;
	 end loop;
   end case;
   W_Io.New_Line;   
end Hello;
