
-- create hierarchical project files with Project.lst file.

with Ada.Text_Io;
use Ada.Text_Io;
with Ada.Command_Line;
use Ada.Command_Line;
with Gnat.Os_Lib;
use Gnat.Os_Lib;
with Ada.Strings.Fixed;
use Ada.Strings.Fixed;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Calendar.Formatting;
use Ada.Calendar;
with Ada.Unchecked_Deallocation;
use Ada;
procedure Project is
   
   
   
   
   procedure To_filename (Line : in out String) is
      Cur : Natural := 0;      
   begin
      Line(Line'First) := To_Upper(Line(Line'First));
      loop
	 Cur := Index(Line, "-");
	 if Cur = 0 then
	    exit;
	 end if;
	 Line(Cur) := '.';
	 Line(Cur+1) := To_Upper(Line(Cur+1));
      end loop;
   end To_Filename;
   
   
   Project_File : File_Type;
   Project_Name : access String;
   
   type String_Access is access all String;
   procedure String_Free is new Unchecked_Deallocation (String, String_Access);
   type String_Array is array (Positive range <>) of String_Access;
   
   type String_Set(Max_Lines : Positive) is
      record
	 Lines : String_Array(1..Max_Lines);
      end record;
   
   Max_Lines : Positive := 16384;
   Last_Index : Natural := 0;
   
   Abstract_File : File_Type;
   
   Gpl_File  : File_Type;
   
   Gpl_Set : String_Set(4096);
   Gpl_Index : Natural := 0;
   
   Prefix : constant String := "--";
   
   Version_File : File_Type;
   
   Version_String : String_Access;
   
   Date : constant String := Formatting.Image(Clock);	
   Char : Character := ' ';
begin
   Put_Line("We are the " & Date);
   Open(Version_File, In_File, "Versions.lst");
   while not End_Of_File(Version_File) loop
      declare
	 Line : constant String := Get_Line(Version_File);
      begin
	 String_Free(Version_String);
	 Version_String := new String ' (Line);
      end;
   end loop;
   Put_Line("The version is " & Version_String.all);
   Open(Abstract_File, In_File, "Abstract.txt");	
   Put_Line("Open Abstract.txt...");	
   declare
      Abstract_Line : constant String := Get_Line(Abstract_File);
   begin
      Close(Abstract_File);
      Open(Gpl_File, In_File, "gpl.txt");	
      Put_Line("Open gtl.txt...");	
      while not End_Of_File(Gpl_File) loop
	 Gpl_Set.Lines(Gpl_Index+1) := new String  ' (Get_Line(Gpl_File));
	 Gpl_Index := Gpl_Index + 1;
      end loop;
      Close(Gpl_File);
      Put_Line("End traitment...");	
      
      if Argument_Count < 1 then
	 Put_Line("Project name requiered.");
	 return;
      else
	 Project_Name := new String ' (Argument(1));
	 if not Is_Regular_File(Project_Name.all) then
	    Put_Line("File name : """ & Project_Name.all & """ is not regulary file.");
	    return;
	 end if;
      end if;
      if Argument_Count > 1 then
	 begin
	    Max_Lines := Integer'Value(Argument(2));
	 exception
	    when Constraint_Error =>
	       Put_Line("Max lines is not a positive.");
	       return;
	 end;
      end if;
      Put("Enter your name : ");
      declare
	 Dir_Table, File_Table : String_Set(Max_Lines);
	 File : File_Type;
	 User_Name : access String;
	 Name_Last : Natural := 0;
      begin	     
         Open(File, In_File, "Copyright");
         declare   
	      Line : String := Get_Line(File);	
	 begin
              User_Name := new String ' (Line);	
	 end; 
	 Close(File);
	 Put("Name ok ! ! ! !  ");
	 Open(Project_File, In_File, Project_Name.all);	
       Put("open project file ");
	 while not End_Of_File(Project_File) loop
	    Dir_Table.Lines(Last_Index + 1) := new String ' (Get_Line(Project_File));
	    Last_Index := Last_Index + 1;
	 end loop;
	 Close(Project_File);
	 
	 
	 for name in 2..Last_Index loop	 
	    File_Table.Lines(Name) := new String ' (Dir_Table.Lines(Name).all);
	 end loop;
	 for name in 2..Last_Index loop	 
	    To_Filename(File_Table.Lines(Name).all);
	 end loop;
	 if not Is_Regular_File(dir_table.lines(1).all & Directory_Separator &
				  dir_table.lines(1).all & 
				  Directory_Separator & "src" & 
				  Directory_Separator & Dir_Table.Lines(1).all & ".adb") then
	   Create(File, Out_File, dir_table.lines(1).all & Directory_Separator &
		    dir_table.lines(1).all & 
		    Directory_Separator & "src" & 
		    Directory_Separator & Dir_Table.Lines(1).all & ".adb");
	         Put("Create adb file: ");
	   Put_Line(File, Prefix & ' ' & Abstract_Line);
	   Put_Line(File, Prefix & ' ' & File_Table.Lines(2).all & ' ' & "is Copyright (C)" & Year_Number'Image(Year(Clock)) & ' ' & User_Name(1..Name_Last) & " ; ");
	   for Gpl_Line in 295..309 loop
	      Put_Line(File, Prefix & Gpl_Set.Lines(Gpl_Line).all(2..Gpl_Set.Lines(Gpl_Line).all'Last));
	   end loop;
	   Put_Line(File, Prefix & ' ' & "Date := " & """" & Date & """");
	   Put_Line(File, Prefix & ' ' & "Version := """ & Version_String.all  & """");
	   
	   for name in 3..Last_Index loop
	      Put_Line(File, "with " & File_Table.Lines(Name).all & " ; ");
	   end loop;
	   
	   
	   Put_Line(File, "procedure " & File_Table.Lines(2).all & " is");
	   New_Line(File);
	   Put_Line(File, "begin");
	   New_Line(File);
	   Put_Line(File, "   null;");
	   Put_Line(File, "end " & File_Table.Lines(2).all & " ; ");
	   Close(File);
	 end if;
	 for name in 3..Last_Index loop	 	 
	    if not Is_Regular_File(dir_table.lines(1).all & Directory_Separator &
		     dir_table.lines(name).all & 
		     Directory_Separator & "src" & 
		     Directory_Separator & "lib" & 
		     Directory_Separator &
				     Dir_Table.Lines(Name).all & ".ads") then
	       
	       Create(File, Out_File, dir_table.lines(1).all & Directory_Separator &
			dir_table.lines(name).all & 
			Directory_Separator & "src" & 
			Directory_Separator & "lib" & 
			Directory_Separator &
			Dir_Table.Lines(Name).all & ".ads");
	       Put_Line(File, Prefix & ' ' & Abstract_Line);
	       Put_Line(File, Prefix & ' ' & File_Table.Lines(2).all & ' ' & "is Copyright (C)" & Year_Number'Image(Year(Clock)) & ' ' & User_Name.all & " ; ");
	       for Gpl_Line in 295..309 loop
		  Put_Line(File, Prefix & Gpl_Set.Lines(Gpl_Line).all(2..Gpl_Set.Lines(Gpl_Line).all'Last));
	       end loop;
	       Put_Line(File, Prefix & ' ' & "Date := " & """" & Date & """");
	       Put_Line(File, Prefix & ' ' & "Version := """ & Version_String.all  & """");
	       
	       
	       Put_Line(File, "package " & File_Table.Lines(Name).all & " is");
	       New_Line(File);
	       Put_Line(File, "end " & File_Table.Lines(Name).all & " ; ");
	       Close(File);
	    end if;
	 end loop;
      end;
   end;
end;
   
