
with Gmface.Gm_Application.Gtk_Step_Sequencer;        use Gmface.Gm_Application.Gtk_Step_Sequencer;
with Gmface.Gm_Application.Gtk_Ctrl_Change;           use Gmface.Gm_Application.Gtk_Ctrl_Change;
with Gmface.Gm_Application.Gtk_Prgm_Change;           use Gmface.Gm_Application.Gtk_Prgm_Change;
  
package body Gmface.Gm_Application.Gtk_Plugins_Initialization is
   --------------------------------------------------------------------------------
   --                                                                            --
   --               Plugins Specifications initializations                       --
   --                                                                            --
   --------------------------------------------------------------------------------
   
   
   
   function Initialize (Class : Plugin_Enum;
   			Plugin : Abstract_Plugin_Access;
			Id : Plugin_num)
   		       return Plugin_Specifications_Access is  
      Spec : Plugin_Specifications_Access;
   begin
      case Class is
   	 when Null_Plugin =>
   	    null;	    
   	 when Step_Seq =>	    
   	    Spec := new Step_Seq_Specifications;
   	    Gtk_Step_Sequencer.Initialize(Step_Seq_Specifications(Spec.all), Plugin);
	 when CC_List =>
	    Spec := new Ctrl_Change_Specifications;
   	    Gtk_Ctrl_change.Initialize(Ctrl_Change_Specifications(Spec.all), Plugin);
	 when PC_List =>
	    Spec := new Prgm_Change_Specifications;
   	    Gtk_Prgm_change.Initialize(Prgm_Change_Specifications(Spec.all), Plugin);
	 when others =>
	    null;
      end case;
      
      return Spec;
   end Initialize;
   
   
end Gmface.Gm_Application.Gtk_Plugins_Initialization;
