
with Glib;                              use Glib;
with Glib.Object;                       use Glib.Object;
with Glib.Values;                       use Glib.Values;
with Gtk.Handlers;                      use Gtk.Handlers;
pragma Elaborate_All (Gtk.Handlers);
with Gtk.Widget;                        use Gtk.Widget;
with Gtk.Enums;                         use Gtk.Enums;
with Gtk.Frame;                         use Gtk.Frame;

with Gtk.Tree_Model;                    use Gtk.Tree_Model;
with Gtk.Scrolled_Window;               use Gtk.Scrolled_Window;
with Gtk.Tree_View_Column;              use Gtk.Tree_View_Column;
with Gtk.Cell_Renderer_Text;            use Gtk.Cell_Renderer_Text;
with Gtk.Cell_Renderer_Toggle;          use Gtk.Cell_Renderer_Toggle;
with Gtk.Tree_Selection;                use Gtk.Tree_Selection;

with Gmface.Gm_Common;                   use Gmface.Gm_Common;
with Gmface.Gm_MIDI.Messages;           use Gmface.Gm_MIDI.Messages;
with Gmface.Gm_Virtual.Gmface.Prgm_change;
use Gmface.Gm_Virtual.Gmface.Prgm_change;


with Text_Io;                           use Text_Io;



package body Gmface.Gm_Application.Gtk_Prgm_Change is
   
   --------------------
   -- step sequencer --
   --------------------
   
   
   package Plugin_Object_CB is new Gtk.Handlers.User_Callback 
     (Gobject_Record,
      Abstract_Plugin_Access);   
   
   
   procedure Muted_Edited (Model  : access GObject_Record'Class;
			   Params : Glib.Values.GValues;
			   Plugin : Abstract_Plugin_Access) is
      
      
      
      
      
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Iter        : constant Gtk_Tree_Iter := Get_Iter_From_String (M, Path_String);
      
      Old_Value   : Boolean := False;
      
      Id : Natural := 0;
      
   begin
      Old_Value := Get_Boolean (M, Iter, Muttable_Column+1);
      
      Id := Integer'Value
	(
	 (Get_String (M, Get_Iter_From_String 
			(M, Get_String (Nth (Params, 1))), Text_Column)));
      
      Prgm_Change_Plugin_Record(Plugin.all).Sequencer(Id).played := not Prgm_Change_Plugin_Record(Plugin.all).Sequencer(Id).Played;      
      Set (M, Iter, Muttable_Column+1, not Old_Value);
   end Muted_Edited;
   
   procedure Loop_Edited (Model  : access GObject_Record'Class;
			  Params : Glib.Values.GValues;
			   Plugin : Abstract_Plugin_Access) is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Iter        : constant Gtk_Tree_Iter := Get_Iter_From_String (M, Path_String);
      
      Old_Value   : Boolean;
      
      Id : Natural := 0;
      
   begin
      Old_Value := Get_Boolean (M, Iter, Loop_Column-2);
      
      Id := Integer'Value
	(
	 (Get_String (M, Get_Iter_From_String 
			(M, Get_String (Nth (Params, 1))), Text_Column)));
      
      
      Prgm_Change_Plugin_Record(Plugin.all).Sequencer(Id).In_Loop := not Prgm_Change_Plugin_Record(Plugin.all).Sequencer(Id).In_Loop;
      Set (M, Iter, Loop_Column-2, not Old_Value);
   end Loop_Edited;
   

   
   procedure MSB_Edited (Model  : access GObject_Record'Class;
   			 Params : Glib.Values.GValues;
   			 Plugin : Abstract_Plugin_Access) is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Text_Value  : constant Gvalue := Nth (Params, 2);
      Iter        : constant Gtk_Tree_Iter :=
   	Get_Iter_From_String (M, Path_String);
      
      
      
      Id : Natural := 0;
      Value : Integer := 0;
   begin
      
      
      Id := Integer'Value
   	(
   	 (Get_String (M, Get_Iter_From_String 
   			(M, Get_String (Nth (Params, 1))), Text_Column)));
      
      begin
   	 Value := Integer'Value(Get_String(Text_Value));      
	 if C.Long(Value) in Value_Type then
	    Prgm_Change_Plugin_Record(Plugin.all).Sequencer(Id).MSB_select := Value_type(Value);
	 end if;
      
   	 Set (M, Iter, MSB_Column, Integer'Image(Value));
      exception
   	 when Constraint_Error =>
   	    null;
      end;
      
   end MSB_Edited;
   
   procedure LSB_Edited (Model  : access GObject_Record'Class;
   			  Params : Glib.Values.GValues;
   			  Plugin : Abstract_Plugin_Access)  is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Text_Value  : constant GValue := Nth (Params, 2);
      Iter        : constant Gtk_Tree_Iter :=
   	Get_Iter_From_String (M, Path_String);
      
      
      
      Id : Natural := 0;
      Value : Integer := 0;
   begin
      
      Id := Integer'Value
   	(
   	 (Get_String (M, Get_Iter_From_String 
   			(M, Get_String (Nth (Params, 1))), Text_Column)));
      begin
   	 Value := Integer'Value(Get_String(Text_Value));
	 if C.Long(Value) in Value_Type then
	    Prgm_Change_Plugin_Record(Plugin.all).Sequencer(Id).LSB_Select := value_Type(Value);
	 end if;
	 
   	 Set (M, Iter, LSB_Column, Integer'Image(Value));
      exception
   	 when Constraint_Error =>
   	    null;
      end;
      
   end LSB_Edited;
   
   procedure Prgm_Edited (Model  : access GObject_Record'Class;
   			    Params : Glib.Values.GValues;
   			    Plugin : Abstract_Plugin_Access)  is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Text_Value  : constant GValue := Nth (Params, 2);
      Iter        : constant Gtk_Tree_Iter :=
   	Get_Iter_From_String (M, Path_String);
      
      
      
      Id : Natural := 0;
      Value : Integer := 0;
   begin
      
      Id := Integer'Value
   	(
   	 (Get_String (M, Get_Iter_From_String 
   			(M, Get_String (Nth (Params, 1))), Text_Column)));
      begin
   	 Value := Integer'Value(Get_String(Text_Value));
	 if C.Long(Value) in Value_Type then
	    Prgm_Change_Plugin_Record(Plugin.all).Sequencer(Id).Prgm_Num := value_Type(Value);
	 end if;
	 
   	 Set (M, Iter, Prgm_Column, Integer'Image(Value));
      exception
   	 when Constraint_Error =>
   	    null;
      end;
      
   end Prgm_Edited;
   
   procedure Bar_Edited (Model  : access GObject_Record'Class;
			 Params : Glib.Values.GValues;
			 Plugin : Abstract_Plugin_Access)  is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Text_Value  : constant GValue := Nth (Params, 2);
      Iter        : constant Gtk_Tree_Iter :=
	Get_Iter_From_String (M, Path_String);
      
      
      
      Id : Natural := 0;
      Value : Integer := 0;
   begin
      
      
      Id := Integer'Value
	(
	 (Get_String (M, Get_Iter_From_String 
			(M, Get_String (Nth (Params, 1))), Text_Column)));      
      begin
	 Value := Integer'Value(Get_String(Text_Value));
	 
	 Prgm_Change_Plugin_Record(Plugin.all).Sequencer(Id).Bar := Value;
      
	 Set (M, Iter, Bar_Column, Integer'Image(Value));
      exception
	 when Constraint_Error =>
	    null;
      end;
      
   end Bar_Edited;
   
   procedure Number_Edited (Model  : access GObject_Record'Class;
			    Params : Glib.Values.GValues;
			 Plugin : Abstract_Plugin_Access)  is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Text_Value  : constant GValue := Nth (Params, 2);
      Iter        : constant Gtk_Tree_Iter :=
	Get_Iter_From_String (M, Path_String);
      
      
      
      Id : Natural := 0;
      Value : Integer := 0;
   begin
      
      Id := Integer'Value
	(
	 (Get_String (M, Get_Iter_From_String 
			(M, Get_String (Nth (Params, 1))), Text_Column)));      
      begin
	 Value := Integer'Value(Get_String(Text_Value));
	 
	 Prgm_Change_Plugin_Record(Plugin.all).Sequencer(Id).Number := Value;
	 
	 Set (M, Iter, Number_Column-3, Integer'Image(Value));
      exception
	 when Constraint_Error =>
	    null;
      end;
      
   end Number_Edited;

   	    
         
   procedure Step_Edited (Model  : access GObject_Record'Class;
			  Params : Glib.Values.GValues;
			 Plugin : Abstract_Plugin_Access)  is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Text_Value  : constant GValue := Nth (Params, 2);
      Iter        : constant Gtk_Tree_Iter :=
	Get_Iter_From_String (M, Path_String);
      
      
      
      Id : Natural := 0;
      Value : Integer := 0;
   begin
      
      
      Id := Integer'Value
	(
	 (Get_String (M, Get_Iter_From_String 
			(M, Get_String (Nth (Params, 1))), Text_Column)));      
      begin
	 Value := Integer'Value(Get_String(Text_Value));
	 
	 Prgm_Change_Plugin_Record(Plugin.all).Sequencer(Id).Step := Value;
	 
	 Set (M, Iter, Step_Column-3, Integer'Image(Value));
      exception
	 when Constraint_Error =>
	    null;
      end;
      
   end Step_Edited;
   
   procedure Note_Edited (Model  : access GObject_Record'Class;
			  Params : Glib.Values.GValues;
			 Plugin : Abstract_Plugin_Access)  is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Text_Value  : constant GValue := Nth (Params, 2);
      Iter        : constant Gtk_Tree_Iter :=
	Get_Iter_From_String (M, Path_String);
      
      
      
      Id : Natural := 0;
      
   begin
      
      
      Id := Integer'Value
	(
	 (Get_String (M, Get_Iter_From_String 
			(M, Get_String (Nth (Params, 1))), Text_Column)));      
      
      Free(Prgm_Change_Plugin_Record(Plugin.all).Sequencer(Id).Note);
      Prgm_Change_Plugin_Record(Plugin.all).Sequencer(Id).Note := new String ' (Get_String (Text_Value));
      
      Set_value (M, Iter, Type_Column+2, Text_value);
   end Note_Edited;
   
   

   ------------------
   -- Add_Name_Line --
   ------------------
   function Add_Prgm_Line
     (Model     : access Gtk_Tree_Store_Record'Class;
      Id        : Integer;      
      MSB       : Integer := 0;
      LSB       : Integer := 0;
      Prgm      : Integer := 0;
      Bar       : Integer := 1;
      Number    : Integer := 1;
      Step      : Integer := 1;
      Note      : String := "";
      Played    : Boolean := True;      
      Muttable  : Boolean := False;            
      In_Loop   : Boolean := False;
      Parent    : Gtk_Tree_Iter := Null_Iter) return Gtk_Tree_Iter
      is
     Iter : Gtk_Tree_Iter;
   begin
      --Put_Line("Add key 1.0");
      Append (Model, Iter, Parent);
      --Put_Line("Add key 1.1");
      Set (Model, Iter, Text_Column, Integer'Image(Id));
      
      Set (Model, Iter, MSB_Column, Integer'Image(MSB));
      Set (Model, Iter, LSB_Column, Integer'Image(LSB));
      
      Set (Model, Iter, Prgm_Column, Integer'Image(prgm));                 
      
      Set (Model, Iter, Bar_Column, Integer'Image(Bar));
      
      Set (Model, Iter, Number_Column-3, Integer'Image(Number));
      
      Set (Model, Iter, Step_Column-3, Integer'Image(Step));
      
      Set (Model, Iter, Type_Column+2, Note);      

      Set (Model, Iter, Muttable_Column+1, Muttable);
            
      
      Set (Model, Iter, Loop_Column-2, In_Loop);
      
      Set (Model, Iter, Editable_Column+9, True);
      
      return Iter;
   end Add_Prgm_Line;
   
   
   
   procedure Bars_Max_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Prgm_Change_Plugin_Record(Plugin.all).Bars_Max := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Bars_Max_Callback;

   package Plugin_Cb is new Gtk.Handlers.User_Callback 
     (Gtk.Widget.Gtk_Widget_Record, 
      Abstract_Plugin_Access);
   
   
   procedure Initialize (Spec : in out Prgm_Change_Specifications;
     			 Plugin : in Abstract_Plugin_Access) is
      
      Scrolled   : Gtk_Scrolled_Window;            
      
      -- Comon Tree      
      Col      : Gtk_Tree_View_Column;
      Num      : Gint;
      Text_Render   : Gtk_Cell_Renderer_Text;
      Toggle_Render : Gtk_Cell_Renderer_Toggle;
      
      Parent, Iter  : Gtk_Tree_Iter;
      pragma Unreferenced (Num);
      pragma Warnings (Off, Iter);
      
      
      Vbox : Gtk_Vbox;
      
   begin
      
      Gtk_New (Spec.Sequencer_Model,
	       (Text_column         => GType_String,
		MSB_Column          => GType_String,
                LSB_Column          => GType_String,
		Prgm_Column         => GType_String,   
		bar_Column          => GType_String,
		Number_Column-3     => GType_String,
		Step_Column-3       => GType_String,
		Type_Column+2       => GType_String,		
		Muttable_Column+1   => GType_Boolean,		
		Loop_Column-2       => GType_Boolean,
		Editable_Column+9   => GType_Boolean)		
	      );
      
      --Put_Line("load Prgm_change 0.1");
      
      Gtk_New (Spec.Sequencer_Tree, Spec.Sequencer_Model);
      --Put_Line("load Prgm_change 0.1.1");
      Set_Grid_Lines (Spec.Sequencer_Tree, Grid_Lines_Vertical);
      --Put_Line("load Prgm_change 0.1.2");
      Set_Enable_Tree_Lines (Spec.Sequencer_Tree, True);
      --Put_Line("load Prgm_change 0.1.3");
      Set_Rubber_Banding (Spec.Sequencer_Tree, True);
      --Put_Line("load Prgm_change 0.1.4");
      Set_Mode (Get_Selection (Spec.Sequencer_Tree), Selection_Multiple);
      --Put_Line("load Prgm_change 0.1.5");
      Gtk_New (Scrolled);
      --Put_Line("load Prgm_change 0.1.6");
      Set_Policy (Scrolled, Policy_Always, Policy_Always);
      --Put_Line("load Prgm_change 0.1.7");
      Add (Scrolled, Spec.Sequencer_Tree);            
      --Put_Line("load Prgm_change 0.1.8");
      
      
      Gtk_New(Spec.Specifications_Frame, "Prgm change sequencer : ");      
      --Put_Line("load Prgm_change 0.1.8.1");
      Gtk_New(Spec.Bars_Max, 1.0, 4096.0, 1.0);
      if Plugin /= null then
	 Set_Value(Spec.Bars_Max, Gdouble(Prgm_Change_Plugin_Record(Plugin.all).Bars_Max));
      end if;
      --Put_Line("load Prgm_change 0.1.8.2");
      
      Plugin_Cb.Connect
        (Spec.Bars_Max, "value_changed", Plugin_Cb.To_Marshaller(Bars_Max_Callback'Access),
	 User_Data => Plugin);
      
      --Put_Line("load Prgm_change 0.1.8.3");
      Gtk_New_Vbox(Vbox, Homogeneous => false);
      Gtk_New_Hbox(Spec.Hbox, Homogeneous => False);
      Gtk_New(Spec.Label, "Bars max : ");
      Pack_Start(Spec.Hbox, Spec.Label, False, False, 2);
      Pack_Start(Spec.Hbox, Spec.Bars_Max, False, False, 2);
      Pack_Start(Vbox, Spec.hbox, False, False, 2);
      Pack_End(Vbox, scrolled);
      Add (Spec.Specifications_Frame, Vbox);      
      --Put_Line("load Prgm_change 0.2");
      
      Gtk_New (Text_Render);
      Gtk_New (Col);
      Num := Append_Column (Spec.Sequencer_Tree, Col);      
      Set_Sort_Column_Id (Col, Id_Column);
      Set_Title (Col, "Id");
      Pack_Start (Col, Text_Render, True);
      Set_Sizing (Col, Tree_View_Column_Autosize);
      Add_Attribute (Col, Text_Render, "text", Text_Column);      
      --Put_Line("load Prgm_change 0.3");
      
      Gtk_New (Text_Render);
      Gtk_New (Col);
      Num := Append_Column (Spec.Sequencer_Tree, Col);
      Set_Sort_Column_Id (Col, MSB_Column);
      Set_Title (Col, "MSB");
      Pack_Start (Col, Text_Render, True);
      Set_Sizing (Col, Tree_View_Column_Autosize);
      Add_Attribute (Col, Text_Render, "text", MSB_Column);          
      Add_Attribute (Col, Text_Render, "editable", Editable_Column+9);
      Plugin_Object_CB.Object_Connect
        (Text_Render, "edited", MSB_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      --Put_Line("load Prgm_change 0.4");
      
      Gtk_New (Text_Render);
      Gtk_New (Col);
      Num := Append_Column (Spec.Sequencer_Tree, Col);      
      Set_Title (Col, "LSB");
      Pack_Start (Col, Text_Render, True);
      Set_Sizing (Col, Tree_View_Column_Autosize);
      Add_Attribute (Col, Text_Render, "text", LSB_Column);
      Add_Attribute (Col, Text_Render, "editable", Editable_Column+9);
      Plugin_Object_CB.Object_Connect
        (Text_Render, "edited", LSB_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      --Put_Line("load Prgm_change 0.5");
      
      Gtk_New (Text_Render);
      Gtk_New (Col);
      Num := Append_Column (Spec.Sequencer_Tree, Col);      
      Set_Title (Col, "Prgm");
      Pack_Start (Col, Text_Render, True);
      Set_Sizing (Col, Tree_View_Column_Autosize);
      Add_Attribute (Col, Text_Render, "text", Prgm_Column);
      Add_Attribute (Col, Text_Render, "editable", Editable_Column+9);
      Plugin_Object_CB.Object_Connect
        (Text_Render, "edited", Prgm_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      
      
      --Put_Line("load Prgm_change 0.6");
      Gtk_New (Text_Render);
      Gtk_New (Col);
      Set_Sort_Column_Id (Col, -1);  --  unsortable
      Num := Append_Column (Spec.Sequencer_Tree, Col);
      Set_Title (Col, "Bar");
      Pack_Start (Col, Text_Render, False);
      Add_Attribute (Col, Text_Render, "text", Bar_Column);      
      Add_Attribute (Col, Text_Render, "editable", Editable_Column+9);
      Plugin_Object_CB.Object_Connect
        (Text_Render, "edited", Bar_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      
      --Put_Line("load Prgm_change 0.7");
      
      Gtk_New (Text_Render);
      Gtk_New (Col);
      Set_Sort_Column_Id (Col, -1);  --  unsortable
      Num := Append_Column (Spec.Sequencer_Tree, Col);
      Set_Title (Col, "Number");
      Pack_Start (Col, Text_Render, False);
      Add_Attribute (Col, Text_Render, "text", Number_Column-3);
      Add_Attribute (Col, Text_Render, "editable", Editable_Column+9);
      Plugin_Object_CB.Object_Connect
        (Text_Render, "edited", Number_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      
      --Put_Line("load Prgm_change 0.8");
      
      Gtk_New (Text_Render);
      --Put_Line("load Prgm_change 0.8.1");
      Gtk_New (Col);
      --Put_Line("load Prgm_change 0.8.2");
      Set_Sort_Column_Id (Col, -1);  --  unsortable
      --Put_Line("load Prgm_change 0.8.3");
      Num := Append_Column (Spec.Sequencer_Tree, Col);
      --Put_Line("load Prgm_change 0.8.4");
      Set_Title (Col, "Step");
      Pack_Start (Col, Text_Render, False);
      --Put_Line("load Prgm_change 0.8.5");
      Add_Attribute (Col, Text_Render, "text", Step_Column-3);
      --Put_Line("load Prgm_change 0.8.6");
      Add_Attribute (Col, Text_Render, "editable", Editable_Column+9);
      --Put_Line("load Prgm_change 0.8.7");
      Plugin_Object_CB.Object_Connect
        (Text_Render, "edited", Step_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      
      --Put_Line("load Prgm_change 0.9");
      Gtk_New (Text_Render);
      Gtk_New (Col);
      Set_Sort_Column_Id (Col, -1);  --  unsortable
      Num := Append_Column (Spec.Sequencer_Tree, Col);
      Set_Title (Col, "Note");
      Pack_Start (Col, Text_Render, False);
      Add_Attribute (Col, Text_Render, "text", Type_Column+2);
      Add_Attribute (Col, Text_Render, "editable", Editable_Column+9);
      Plugin_Object_CB.Object_Connect
        (Text_Render, "edited", Note_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      --Put_Line("load Prgm_change 0.10");
      
      Gtk_New (Toggle_Render);
      Gtk_New (Col);
      Set_Sort_Column_Id (Col, -1);  --  unsortable
      Num := Append_Column (Spec.Sequencer_Tree, Col);
      Set_Title (Col, "Mute");
      Pack_Start (Col, Toggle_Render, False);      
      Add_Attribute (Col, Toggle_Render, "active", Muttable_Column+1);      
      Plugin_Object_CB.Object_Connect
        (Toggle_Render, "toggled", Muted_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      
      --Put_Line("load Prgm_change 0.11");
      
      Gtk_New (Toggle_Render);
      Gtk_New (Col);
      Set_Sort_Column_Id (Col, -1);  --  unsortable
      Num := Append_Column (Spec.Sequencer_Tree, Col);
      Set_Title (Col, "In loop");
      Pack_Start (Col, Toggle_Render, False);      
      Add_Attribute (Col, Toggle_Render, "active", Loop_Column-2);      
      Plugin_Object_CB.Object_Connect
        (Toggle_Render, "toggled", loop_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      --Put_Line("load Prgm_change 0.12");
      
      
      --Put_Line("load Prgm_change 0.13");
      Parent := Null_Iter;
      --Put_Line("load Prgm_change 0.14");
      for Count in Prgm_Change_Plugin_Record(Plugin.all).Sequencer'range loop	 
	 declare
	    Voice : constant Prgm_Change_Type := Prgm_Change_Plugin_Record(Plugin.all).Sequencer(Count);
	 begin
	    
	    --Put_Line("load Prgm_change 0.15");
	    
	    Iter := Add_Prgm_Line
	      (Spec.Sequencer_Model, 
	       Id => count,
	       MSB => Integer(Voice.MSB_select),
	       LSB => Integer(Voice.LSB_select),
	       Prgm => Integer(Voice.Prgm_num),
	       Bar => Integer(Voice.Bar),
	       Number => Integer(Voice.Number),
	       Step => Integer(Voice.Step), 
	       Note => Voice.Note.all,
	       Played => Voice.Played,
	       Muttable => not Voice.Played,	      	       
	       In_Loop => Voice.In_Loop,
	       Parent => Parent);

	    
	    --Put_Line("load Prgm_change 0.16");
	 end;
      end loop;            
      -- End Sequencer View
      --Put_Line("load Prgm_change 1.0");

      
      
   end Initialize;
   
   
   --  procedure Load_specifications (Page : in out Plugin_Page_Type;
   --  				  Plugin : in Abstract_Plugin_Access;
   --  				  Id : in Plugin_Num) is
   --     --  Scrolled   : Gtk_Scrolled_Window;            
      
   --     --  -- Comon Tree      
   --     --  Col      : Gtk_Tree_View_Column;
   --     --  Num      : Gint;
   --     --  Text_Render   : Gtk_Cell_Renderer_Text;
   --     --  Toggle_Render : Gtk_Cell_Renderer_Toggle;
      
   --     --  Parent, Iter  : Gtk_Tree_Iter;
   --     --  pragma Unreferenced (Num);
   --     --  pragma Warnings (Off, Iter);
      
      
   --     --  Vbox : Gtk_Vbox;
      
   --  begin
   --     Page.Plugin_Spec := Initialize(Plugin.Class, Plugin, Id);--New Prgm_Change_Plugin_Specifications;
   --  end Load_Specifications;
   
end Gmface.Gm_Application.Gtk_Prgm_Change;
