
with Ada.Calendar;                      use Ada.Calendar;
with Ada.Unchecked_Deallocation;

package Gmface.Gm_Common is
   
   type String_Access is access all String;
   procedure Free is new Ada.Unchecked_Deallocation(String, String_Access);
   
   
   Time_Unit_Max : constant Positive := 64;
   
   Time_Number_Max : constant Positive := 32;
   
   Time_Index_Max : constant Positive := Time_Unit_Max * Time_Number_Max;
   
   subtype Time_Index_Type is
     Positive range Positive'First .. Time_Index_Max;
   
   subtype Extended_Time_Index_Type is
     Natural range 0 .. Time_Index_Max;
      
   
   subtype Time_Number_Type is
     Time_Index_Type range Time_Index_Type'First..Time_Number_Max;
   
   Number_Default : constant Time_Number_Type := Time_Number_Type'Last / 2;
   
   
   subtype Time_Unit_Type is
     Time_Index_Type range Time_Index_Type'First .. Time_Unit_Max;
   
   Unit_Default : constant Time_Unit_Type := Time_Unit_Type'Last / 4;
         
   type Time_Signature_Type is
      record
   	 Number   : Time_Number_Type := Number_Default;
   	 Unit     : Time_Unit_Type   := Unit_Default;
      end record;
   
   type Tempo_Type is delta 0.1 digits 4 range 1.0..240.0;
   
   function Integer_Image (Value : in Integer) return String;
      
   procedure Difference_In_Years(Top_Date : in Time;
                                 Bot_Date : in Time;
                                 Years    : out Natural;
                                 Months   : out Natural;
                                 Days     : out Natural;
                                 Houres   : out Natural;
                                 Minutes  : out Natural;
                                 Second   : out Natural;
                                 Rest     : out Duration);
end Gmface.Gm_Common;
