with Gmface.Gm_Common;                    use Gmface.Gm_Common;
with Gmface.Gm_Virtual;                   use Gmface.Gm_Virtual;
with Gmface.Gm_MIDI.Messages;             use Gmface.Gm_MIDI.Messages;
with Gmface.Gm_Virtual.Gmface.Gmface_Plugins;
use Gmface.Gm_Virtual.Gmface.Gmface_Plugins;
package Gmface.Gm_Virtual.Gmface.Ctrl_Change is
   
   type Ctrl_Change_Type is
      record
	 Ctrl_Name : access String := new String ' ("");
	 Ctrl_Num : Value_Type := 1;
	 Ctrl_Val : Value_Type := 1;
	 
	 Id      : Positive := 1;
	 Bar     : Positive := 1;
	 Number  : Time_Number_Type := 1;
	 Step    : Time_Unit_Type := 1;
	 Played  : Boolean := False;
	 Note    : String_Access := new String ' ("");
	 In_Loop : Boolean := False;	 
      end record;
   
   type Cc_Array is array (Positive range <>) of Ctrl_Change_Type;
   
   
   type Ctrl_Change_Plugin_Record is
     new Gmface_Plugin_Class(CC_List) with
      record
	 Sequencer : Cc_Array(1..128);
	 Bars_Max  : Positive := 128;
      end record;
   procedure Print (Filename : in String; Plug : in Ctrl_Change_Plugin_Record);
end Gmface.Gm_Virtual.Gmface.Ctrl_Change;
