with Ada.Numerics.Discrete_Random;

with Gmface.Gm_Virtual.Gmface.Gmface_Plugins;  use Gmface.Gm_Virtual.Gmface.Gmface_Plugins;
with Ada.Calendar;
package Gmface.Gm_Virtual.Gmface.Gmface_Work is
   
   
   type Bar_Beat_Type is
     tagged record
      Bar         : Positive := Positive'First;
      Time_Number : Time_Number_Type := Time_Number_Type'First;      
      Time_Unit   : Time_Unit_Type := Time_Unit_Type'First;
   end record;
   
   function image(Signature : in Time_Signature_Type) return String;
   
   function Image(Bar_Beat : in Bar_Beat_Type) return String;
   
   procedure Next(Bar_Beat    : in out Bar_Beat_Type;
		  Bar         : in Natural;
		  Number      : in Time_Number_Type;
		  Unit        : in Time_Unit_Type);
   
   type States_Record is tagged
      record
	 Start_Time : Ada.Calendar.Time := Ada.Calendar.Clock;	 
	 Bar_Beat : Bar_Beat_Type := (1, 1, 1);
	 Elapsed    : Duration := 0.0;
      end record;
   
   
   
   type Gmface_Plugin_Access is access all Gmface_Plugin_Class'Class;
      
   
   package Break_Rand is new Ada.Numerics.Discrete_Random(Break_Type);   
   
   package Form_Rand is new Ada.Numerics.Discrete_Random(Form_Index_Type);   
   
   
   
   
   
   type Gmface_Options_Record is new Work_Options_Record with
      record
	 null;
      end record;
   
   
   type Gmface_Options_Access is access all Gmface_Options_Record;
   
   type Gmface_Work_Record is new Work_Class with
      record
	 Current_Form : Form_Index_Type := 1;	 
	 Options      : Gmface_Options_Access := new Gmface_Options_Record;
	 States       : States_Record;	 
      end record;
   
   type Gmface_Work_Access is access all Gmface_Work_Record;
   
   procedure Initialize(Work : in out Gmface_Work_Record;
			Work_Id : in Work_Num;
			Filename : in String);
   
   procedure Save(Work : in out Gmface_Work_Record;
		  Filename : in String := "");
   
   
   
   
   function Initialize(Class : in Plugin_Enum;
		       Id        : in Plugin_num;
		       Device    : in Device_Num;
		       Ch        : in Channel_Num;
		       Form      : in Form_Index_Type;
		       cat       : in Category_Index_Type)
     
		      return Abstract_Plugin_Access;
      
end Gmface.Gm_Virtual.Gmface.Gmface_Work;
