
with Ada.Numerics.Discrete_Random;

with Text_Io;                           use Text_Io;
package body Gmface.Gm_Virtual is
   -------------------------------------------------------------
   --
   
   function Is_Formed(True_Table : True_Table_Type;
		      Category_Index : Category_Index_Type;
		      Prev       : Break_Type := Null_Break;
		      Next       : Break_Type := Null_Break) return Boolean is
      

   begin
      return True_Table(Category_Index, Prev, Next);

   end Is_Formed;
   
   
   package Bool_Rand is new Ada.Numerics.Discrete_Random(Boolean);
   
   procedure True_Table_Initialize(True_Table : in out True_Table_Type) is
      
      Bool_Gen : Bool_Rand.Generator;
      
   begin	 
      Bool_Rand.Reset(Bool_Gen);
      
      for Next_Id in Break_Type'Range loop
	 for Prev_Id in Break_Type'Range loop
	    for Category_Id in Category_Index_Type'Range loop		  		  
	       True_Table(Category_id, Prev_id, Next_id) := 		 
		 Bool_Rand.Random(Bool_Gen) or Bool_Rand.Random(Bool_Gen) or
		 Bool_Rand.Random(Bool_Gen) or Bool_Rand.Random(Bool_Gen);
	    end loop;
	 end loop;
      end loop;      
   end True_Table_Initialize;
   
   
   --
   --------------------------------------------------------------
   
      
   procedure Initialize (Plug      : in out Plugin_Class;
			 Id        : in Plugin_Num;
			 Device    : in Device_Num;
			 Ch        : in Channel_Num) is
   begin
      Plug.Id := Id;
      Plug.Device_Id := Device;
      Plug.Ch_Id := Ch;
   end Initialize;
   
   procedure Set_Id(Plug       : in out Plugin_Class;
		    Id        : in Plugin_Num) is
   begin
      Plug.Id := Id;
   end Set_Id;
   
   function Get_Id(Plug        : in Plugin_Class) return Plugin_Num is
   begin
      return Plug.Id;
   end Get_Id;
   
   procedure Set_Device(Plug       : in out Plugin_Class;
			Device    : in Device_Num) is
   begin
      Plug.Device_Id := Device;
   end Set_Device;
   
   function Get_Device(Plug        : in Plugin_Class) return Device_Num is
   begin
      return Plug.Device_Id;
   end Get_Device;
   
   procedure Set_Channel(Plug       : in out Plugin_Class;
			 Ch        : in Channel_Num) is
   begin
      Plug.Ch_Id := Ch;
   end Set_Channel;
   
   function Get_Channel(Plug        : in Plugin_Class) return Channel_Num is
   begin
      return Plug.Ch_Id;
   end Get_Channel;
   
   

   procedure Print(Filename : in String; Plug : in Plugin_Class) is
      File : File_Type;
   begin
      Open(File, Append_File, Filename);      
      Put_Line(File, Boolean'Image(Plug.Printed));
      Put_Line(File, Boolean'Image(Plug.Mutted));            
      Put_Line(File, Channel_Num'Image(Plug.Ch_Id));      
      Put_Line(File, Device_Num'Image(Plug.Device_Id));
      Put_Line(File, Plug.Name.all);
      Close(File);
   end Print;
end Gmface.Gm_Virtual;
