with Gn.Entity;                         use Gn.Entity;
with Gtk.Label;                         use Gtk.Label;
with Gtk.Widget;                        use Gtk.Widget;
package body Gn.Logos.X.Gtk_Lib.bonjour_le_monde is
   
   function Gtk_New (Gn_Dialog : not null access Gn_Dialog_Record'class;
		     Parent : in Gtk_window;
		     Identity : in Identity_Access;
		     Iter     : in Natural) return Gtk_Response_Type is
      
      Widget : Gtk_Widget;
      The_Response : Gtk_Response_Type;
      Label : Gtk_Label;
      
      Entity : Entity_Access;
      
      Logname : access String;
      
   begin
      if Get_Entity(Identity.all, "LOGNAME") /= null then
	 Entity := Get_Entity(Identity.all, "LOGNAME");
      elsif Get_Entity(Identity.all, "USERNAME") /= null then
	 Entity := Get_Entity(Identity.all, "USERNAME");
      end if;
      if Entity /= null then
	 Logname := new String ' (Entity.Image.all);
      else
	 Logname := new String ' ("le monde");
      end if;
      loop
	 declare
	    task type Dialog_Process is		  
	    end Dialog_Process;
	    task body Dialog_Process is
	       
	       
	       
	    begin
	       delay 5.0;
	       if Gn_Dialog.Dialog /= null then
		  Gtk.Dialog.Response(Gn_Dialog.Dialog, Gtk_Response_None);
	       end if;
	    end Dialog_Process;
	    
	    Verax : Boolean := False;
	 begin
	    Gtk_New(Gn_Dialog.Dialog, "Gnalog ""bonjour""", Parent, Modal);
	    Set_Default_Size(Gtk_Window(Gn_Dialog.Dialog), 250, 85);
	    declare
	       Box : constant Gtk_Box := Get_Content_Area(Gn_Dialog.Dialog);
	    begin	 
	       Gtk_New(Label, "bonjour " & Logname.all & " ! ");
	       Pack_Start(Box, Label);
	       case Iter is
		  when 0 =>
		     Widget := Add_Button(Gn_Dialog.Dialog, "Ok", Gtk_Response_Ok);
		  when 1 =>
		     Widget := Add_Button(Gn_Dialog.Dialog, "Ok", Gtk_Response_Ok);
		     Widget := Add_Button(Gn_Dialog.Dialog, "Annuler", Gtk_Response_Cancel);
		     Gtk_New(Label, "S'il vous plait, répondez " & Logname.all & " ! ");
		     Pack_Start(Box, Label);
		  when others =>
		     Widget := Add_Button(Gn_Dialog.Dialog, "Oui", Gtk_Response_Yes);
		     Widget := Add_Button(Gn_Dialog.Dialog, "Non", Gtk_Response_No);
		     Gtk_New(Label, "Continuer " & Logname.all & " ? ");
		     Pack_Start(Box, Label);
		     
		     Gtk_New(Label, "S'il vous plait, répondez par oui ou non " & Logname.all & " ! ");
		     Pack_Start(Box, Label);
	       end case;	       
	       Show_All(Gn_Dialog.Dialog);		  		  
	    end;
	    declare
	       
	       Dialog : Dialog_Process;
	    begin
	       The_Response := Run(Gn_Dialog.Dialog);
	       case The_Response is
		  when Gtk_Response_Ok =>
		     Destroy(Gn_Dialog.Dialog);	       
		     abort Dialog;
		     return The_Response;
		  when Gtk_Response_None =>
		     Destroy(Gn_Dialog.Dialog);	       
		     abort Dialog;
		     return The_Response;
		  when others =>
		     Destroy(Gn_Dialog.Dialog);	       
		     abort Dialog;
		     return The_Response;
	       end case;
	    end ;
	    
	 end;
      end loop;
   exception
      when others =>
	 return The_Response;	 	 
   end Gtk_New;
   
end Gn.Logos.X.Gtk_Lib.Bonjour_Le_Monde;
