--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 19:33:08 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.12.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
with Ada.Wide_Text_Io;
with Ada.Text_Io;
use Ada;

package body Gnos.Machines is
   
   procedure initialize(Language_Context : in out Language_Context_Record;
			Language_Params  : in Language_Parameters_Type) is
   begin
      Language_Context.Language_params := Language_Params;      
      Agnose_Projects.Initialize(Projects_Context_Record(Language_Context), Projects_Parameters_Type(Language_Params));
   end Initialize;
   
   procedure Load_project(Language_Context : in out Language_Context_Record;			
			  Ada_Path : in String;
			  Gtk_Path : in String;
			  Aws_Path : in String;
			  Project_Path : in String) is
      
      Ada_Type : constant Ada_With_Type := Ada_With_Type'Val(Boolean'Pos(Language_Context.Language_Params.With_Ada));
      Gtk_Type : constant Gtk_With_Type := Gtk_With_Type'Val(Boolean'Pos(Language_Context.Language_Params.With_Gtk));
      Aws_Type : constant Aws_With_Type := Aws_With_Type'Val(Boolean'Pos(Language_Context.Language_Params.With_Aws));
      
   begin
            

      case Gtk_Type is
	 when Without_Gtk =>
	    case Ada_Type is
	       when without_Ada =>
		  		  
		  Language_Context.Project := new Project_Without_Ada_Record_Type(Without_Gtk);
	       when others =>
		  
		  Language_Context.Project := new Project_With_Ada_Record_Type(Without_Gtk);
		  Language_Context.Project.Load_Ada(Path_Name => Ada_Path);
	    end case;      
	 when others =>
	    case Ada_Type is
	       
	       when without_Ada =>
		  
		  Language_Context.Project := new Project_Without_Ada_Record_Type(With_Gtk);
	       when others =>
		  
		  Language_Context.Project := new Project_With_Ada_Record_Type(With_Gtk);
		  Language_Context.Project.Load_Ada(Path_Name => Ada_Path);
	    end case;
	    
	    Language_Context.Project.Load_GtkAda(Path_Name => Gtk_Path);
      end case;

      case Aws_Type is
	 when Without_Aws =>
	    null;
	 when others =>	    
	    
	    Language_Context.Project.Load_Aws(Path_Name => Aws_Path);
      end case;
      
      Language_Context.Project.Load_Project(Project_Path);
      
   end Load_Project;	 
   
   

   function Check_Parameters(Language_Context : in Language_Context_Record'Class;
			     Params : in Parameters.Language_Parameters_Type'class) return Boolean is
      
      Checked : Boolean := False;
      
   begin
      Wide_Text_Io.Put("Language Context :");
      Checked := Language_Context.Language_Params = Language_Parameters_Type(Params);
      
      if not Checked then	 
	 if Language_Context.Language_Params.Char_Max /= Language_Parameters_Type(Params).Char_Max then
	    Text_Io.New_Line;
	    Text_Io.Put_Line("Char_Max : " & 
		       Integer'Image(Language_Context.Language_Params.Char_Max) & " /= " &
		       Integer'Image(Language_Parameters_Type(Params).Char_Max));
	 end if;
	 if Language_Context.Language_Params.Version /= Language_Parameters_Type(Params).Version then
	    Text_Io.Put_Line("Version : " & 
		       Integer'Image(Language_Context.Language_Params.Version) & " /= " &
		       Integer'Image(Language_Parameters_Type(Params).Version));	    
	 end if;
	 raise Program_Error;
      end if;
      Wide_Text_Io.Put("Ok, ");
      Checked := Checked and Agnose_Projects.Check_Parameters(Projects_Context_Record(Language_Context), params);
      return Checked;
   end Check_Parameters;
   
   
   procedure Load_Language(Language_Set : in out Language_Set_Array_Type; Machine_Lang : in Machine_Lang_Enum) is
      
   begin
      Text_Io.Put_Line("Creating Machine Language for : " & Machine_Lang_Enum'Image(Machine_Lang));
      Language_Set(Machine_Lang) := new Language_Unit_Record ' (Machine_Lang => Machine_Lang);
   end Load_Language;
   
end Gnos.Machines;
