--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 19:33:08 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.12.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
with Ada.Wide_Text_Io;
with Ada.Text_Io;
use Ada;

package body Gnos.Neural is
   
   procedure initialize(Neural_Context : in out Neural_Context_Record;
			Neural_Params  : in Neural_Parameters_Type) is
   begin
     
      Neural_Context.Neural_Params := Neural_Params;
      Objects_System.Initialize(System_Context_Record(Neural_Context), System_Parameters_Type(Neural_Params));
   end Initialize;
   
   procedure Load_Project(Neural_Context : in out Neural_Context_Record;
			  Ada_Path : in String;
			  Gtk_Path : in String;
			  Aws_Path : in String;
			  Project_Path : in String) is
   begin
      
      
      
      Objects_System.Load_project(System_Context_Record(Neural_Context), Ada_Path, Gtk_Path, Aws_Path, Project_Path);
   end Load_Project;
   
   
   function Check_Parameters(Neural_Context : in Neural_Context_Record;
			     Params : in Neural_Parameters_Type) return Boolean is
      
      Checked : Boolean := False;
      
   begin
      
      Wide_Text_Io.Put("Neural Context :");
      
      Checked := Neural_Context.Neural_Params = Neural_Parameters_Type(Params);
      
      if not Checked then
	 Text_Io.New_Line;
	 if Neural_Context.Neural_Params.Self_Wait /= Neural_Parameters_Type(Params).Self_Wait then
	    Text_Io.Put_Line("Self_Wait : " & 
			       Duration'Image(Neural_Context.Neural_Params.Self_Wait) & " /= " &
			       Duration'Image(Neural_Parameters_Type(Params).Self_Wait));
	 end if;
	 if Neural_Context.Neural_Params.User_Wait /= Neural_Parameters_Type(Params).User_Wait then
	    Text_Io.Put_Line("User_Wait : " & 
			       Duration'Image(Neural_Context.Neural_Params.User_Wait) & " /= " &
			       Duration'Image(Neural_Parameters_Type(Params).User_Wait));	    
	 end if;
	 raise Program_Error;
      end if;
      
      Wide_Text_Io.Put("Ok, ");
      
      Checked := Checked and Objects_System.Check_Parameters(Neural_Context, Params);      
      return Checked;
   end Check_Parameters;
   

   procedure Load_Network(Neural_Set : in out Neural_Set_Array_Type; Human_Lang : in Human_Lang_Enum) is
   begin
      Neural_Set(Human_Lang) := new Neural_Unit_Record ' (Human_Lang => Human_Lang);
   end Load_Network;
   
end Gnos.Neural;
