--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Agnostic is Ada% Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 19:33:08 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.12.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------

with Gnos.Parameters;
with Gnos.Classified;
use Gnos.Classified;
with Gnos.Engineering;
use Gnos.Engineering;
with Gnos.Versions;
with Gnos.Versions.Editting;
generic
   Params : Parameters.projects_Parameters_Type;
package Gnos.Projects is            
   
   
   subtype Name_Type is String(1..Params.Name_Length);
   
   type Ada_With_Type is (Without_Ada, With_Ada);
   type Gtk_With_Type is (Without_Gtk, With_Gtk);
   type Aws_With_Type is (Without_Aws, With_AWS);
            
   type Abstract_Unit_Type is abstract tagged
      record	 
	 Unit_Name : Name_type;
	 File_Name : Name_type;
	 Path_Name : Name_type;
      end record;
            
   type Unit_Record_Type is new Abstract_Unit_Type with
      record
	 Path_Dir : Name_type;
      end record;
   
   subtype Unit_Index_Type is Positive range 1..Params.Unit_Max;
   
   
   type Unit_Array_Type is array (Unit_Index_Type range 1..Unit_Index_Type'last) of Unit_Record_Type;
   
   type Main_Record_Type is new Abstract_Unit_Type with
      record
	 Path_Dir : Name_type;	 	 	 	 
      end record;
      
   
   type Library_Record_Type is new Abstract_Unit_Type with
      record
	 Path_Dir : Name_type;
	 Library_unit : Unit_Array_Type;
	 Unit_Index   : Natural := 0;	 
      end record;
   
   
   type Project_Record_Type(Ada_With : Ada_With_Type) is new Data_Class with
      record	 	 
	 Project_Prefix : access String;
	 Project_Name : access String;	 	 
	 Working_Directory : access String := new String ' (".");	 
	 Main         : Main_Record_Type;
	 Proj_Library : Library_Record_Type;	 
	 Gtk_Library  : Library_Record_Type;
	 Aws_Library  : Library_Record_Type;
	 case Ada_With is
	    when Without_Ada =>
	       null;
	    when others =>
	       Ada_Library : Library_Record_Type;
	 end case;	 
      end record;
   
   
   
   type Project_Access is access all Project_Record_Type'Class;
   
   type Projects_Context_Record is tagged
      record
	 Ada_Path : access Wide_String;
	 Gtk_Path : access Wide_String;
	 Aws_Path : access Wide_String;
	 Pro_Path : access Wide_String;
	 Projects_Params : Parameters.Projects_Parameters_Type := Projects.Params;
	 Project : Project_Access;
      end record;
      
   type Project_Without_Ada_Record_Type(Gtk_With : Gtk_With_Type) is new Project_Record_Type(Without_Ada) with 
     null record;	 
   
   type Project_With_Ada_Record_Type(Gtk_With : Gtk_With_Type) is new Project_Record_Type(With_Ada) with
     null record;
   
   Project_Default : constant String := "Project.default";      
   
   use Parameters;
   
   procedure initialize(Projects_Context : in out Projects_Context_Record'Class;
			Projects_Params  : in Projects_Parameters_Type);
   
   procedure Load_Project(Project : out Project_Record_Type'Class; 
			  Path_Name : in String);   
   procedure Load_Ada(Project : in out Project_Record_Type'Class;
		      Path_Name : in String);
   procedure Load_GtkAda(Project : in out Project_Record_Type'Class;
			 Path_Name : in String);
   procedure Load_Aws(Project : in out Project_Record_Type'Class;
		      Path_Name : in String);   
   
   function Check_Parameters(Projects_Context : in Projects_Context_Record'Class;
			     Params : in Projects_Parameters_Type'class) return Boolean;      
   
   
end Gnos.Projects;
