-- Skywalker is another attempt of A. i. written with Ada.
-- Skywalker is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2024-11-11 15:42:20"
-- Version := "0.0.2r"
with Gnat.Os_Lib;
use Gnat.Os_Lib;
with Gnat.Command_Line;
with Text_Io;
use Text_Io;
with Ada.Strings.Fixed;
use Ada.Strings.Fixed;
use Ada.Strings;
package body Sky.Shell is
   
   procedure Alias (Line : in String; Alias_Set : in out Attributs) is
      
      Command : Gnat.Command_Line.Command_Line;
      
      Args_List : Argument_List_Access;                  
      --Buffer : U_Array_Access := Result.Wlines;
      Name   : String_Access;
      
      Image  : String_Access;
      Alias  : Attribut_Record;
   begin      
      Gnat.Command_Line.Set_Command_Line(Command, Line);
      Gnat.Command_Line.Build(Command, Args_List, False);
      
      if Args_List'Last > 2 then
	 --Buffer := Add_Line(Buffer, "alias : error : ");
	 --Buffer := Add_Line(Buffer, "                -- To many argument in command --");
	 --Buffer := Add_Line(Buffer, "                -- Try 'help cd' for more info --");
	 return;
      elsif Args_List'Last = 2 then
	 
	 if Args_List(2) /= null and then Args_List(2).all /= "" then
	    
	    Parse(Line, Name, Image);
	    
	    Alias := Make(Name.all, Image.all);
	    
	    Alias_Set.list(Alias_Set.Index + 1) := Alias;
	    Alias_Set.Index := Alias_Set.Index + 1;
	 end if;
      else
	 
	 for Iter in 1..Alias_Set.Index loop
	    
	    Put_Line(Names(Alias_Set.list(Iter)) & '=' & images(Alias_Set.list(Iter)));
	 end loop;
	 
      end if;
      
      
   exception
      when others =>
	 
	 null;
   end Alias;
   
   procedure Unalias (Line : in String; Alias_Set : in out Attributs) is
      
      Command : Gnat.Command_Line.Command_Line;
      Args_List : Argument_List_Access;                  
   begin      
      Gnat.Command_Line.Set_Command_Line(Command, Line);
      Gnat.Command_Line.Build(Command, Args_List, False);
      
      if Args_List'Last > 2 then
	 
	 return;
      elsif Args_List'Last = 2 then	 
	 if Args_List(2) /= null and then Args_List(2).all /= "" then
	    for Iter in 1..Alias_Set.Index loop
	       declare
		  Alias : constant Attribut_Record := Alias_Set.List(Iter);
	       begin
		  if Names(Alias) = Args_List(2).all then
		     for Left in Iter..Alias_Set.Index loop
			Alias_Set.List(Left) := Alias_Set.List(Left+1);
			Alias_Set.Index := Alias_Set.Index - 1;
		     end loop;
		     exit;
		  end if;
	       end;
	    end loop;
	    
	 end if;      
      end if;

   exception
      when others =>
	 null;
	 
   end Unalias;
   
   procedure Set (Line : in String; Var_Set : in out Attributs) is
   begin
      Alias(Line, Var_Set);      
   end Set;
   
   procedure Unset (Line : in String; Var_Set : in out Attributs) is
   begin
      Unalias(Line, Var_Set);
   end Unset;
   
   procedure Put(Name : in String;  Var_Set : in out Attributs) is
   begin
      for Iter in 1..Var_Set.Index loop
	 if Names(Var_Set.list(Iter)) = Name then

	    Text_Io.Put(images(Var_Set.list(Iter)));
	 end if;
      end loop;	 
   end Put;
   
   procedure Put_Line(Name : in String;  Var_Set : in out Attributs) is
   begin
      
      Put(Name, Var_Set);
      New_Line;
   end Put_Line;
   
   function Internal_Cmd_Value (Line : in String) return Int_Cmd_Enum is
      Cmd : Int_Cmd_Enum  := None;
      First_Space : constant Natural := Index(Line, " ");
   begin
      
      if First_Space /= 0 then
	 begin
	    
	    Cmd := Int_Cmd_Enum'Value(Line(Line'First..First_Space-1));
	    
	 exception
	    when others =>
	       Cmd := None;
	 end;
	 
      elsif Index_Non_Blank(Line) /= 0 then
	 begin
	    Cmd := Int_Cmd_Enum'Value(Line(Index_Non_Blank(Line)..Index_Non_Blank(Line, Backward)));
	 exception
	    when others =>
	       Cmd := none;
	 end;
	 
      end if;
      return Cmd;
   end Internal_Cmd_Value;
   
   
   
   function Command_Name (Line : in String) return String is
   begin
      if Line'Length = 0 then
	 return "";
      elsif Index_Non_Blank(Line) = 0 then
	 return "";
      elsif (Index(Line, " ") > Index_Non_Blank(Line)) then
	 return Line(Index_Non_Blank(Line)..Index(Line, " ")-1);
      else
	 return Line;
      end if;
   end Command_Name;

end Sky.Shell ; 
