-- Skywalker is another attempt of A. i. written with Ada.
-- Skywalker is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2024-11-13 06:51:20"
-- Version := "0.0.10r"
package Sky.Stock is
   
   pragma Pure(Sky.Stock);
   
   Stock_Num_Max : constant Natural := 2048;
   
   subtype Stock_Num_Range is Natural range 0..Stock_Num_Max;
   
   type Stock_Record is tagged
      record
	 Num      : Stock_Num_Range := 0;
	 Name     : Product_Name      := (others => ' ');
	 Quantity : Quantity_Range := 0.0;
	 Unit_Ht  : Fixed_Unit_Ht := 0.0;
	 TVA_Rate : Fixed_Factor := 0.0;
      end record;
   
   Null_Stock : constant Stock_Record := (0, (others => ' '), 0.0, 0.0, 0.0);

end Sky.Stock ; 
