-- Skywalker is another attempt of A. i. written with Ada.
-- Skywalker is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2024-11-11 15:56:20"
-- Version := "0.0.2r"
with Ada.Strings.Wide_Unbounded;
with Sky.Strings;
use Sky.Strings;
with Ada.Unchecked_Deallocation;
with Gnat.os_Lib;
use Gnat.Os_Lib;
package Sky.Tools is
   
   subtype U_String is Ada.Strings.Wide_Unbounded.Unbounded_Wide_String;
   use type U_String;
   
   function "+"(S: Wide_String) return U_String
     renames Ada.Strings.Wide_Unbounded.To_Unbounded_Wide_String;
   
   function "-"(U: U_String) return Wide_String
     renames Ada.Strings.Wide_Unbounded.To_Wide_String;
   
   type U_Array is array(Positive range <>) of U_String;
   
   type U_array_Access is access U_Array;
   
   procedure U_array_Free is new Ada.Unchecked_Deallocation 
     (U_Array, U_Array_Access);
   
   
   type Result_Enum is (File, Search, Spawn);
   
   type Result_Record (Name : Result_Enum) is tagged
      record
	 Wlines : U_Array_Access;
	 Count  : Natural := 0;
	 Initialized : Boolean := False;
	 case Name is
	    when File =>
	       null;
	    when Search =>
	       Pattern   : Wide_String_Access := new Wide_String ' ("");
	       Address   : String_Access;
	       Doc_Name  : Wide_String_Access;
	    when Spawn =>
	       Process_Id     : Gnat.Os_Lib.Process_Id;
	       Program_Name   : U_String;
	       Args           : Argument_List_Access;	 
	       Output_File    : U_String;
	       Success        : Boolean := False;
	       Return_Code    : Integer := 0;
	       Err_To_Out     : Boolean := False;	 
	 end case;
	 
      end record;   
   
   type Wide_Result_Access is access all Result_Record'Class;
   
   procedure Wide_Result_Free is new Ada.Unchecked_Deallocation(Result_Record'Class, Wide_Result_Access);
   
   type Spawn_Result_Record is new Result_Record(Spawn) with null record;
   type File_Result_Record is new Result_Record(File) with null record;
   type Search_Result_Record is new Result_Record(Search) with null record;

   
   function Delete_Local_Prefix(Filename : in String) return String;
   function Normalize_Quoted_Argument(Arg : in String) return String;
   function Search_Regexp (Path : in String;
                           Pattern : in String) return String;
   function Expand_filename (Line : in String) return String;
   procedure Change_directory (Line : in String;Old_Pwd : in out String_Access);
   procedure Find_At_Path (Path : in String;
			   Pattern : in String;
			   Result : in Wide_Result_Access);
   procedure Completion (Line : in String;
			 Full_Command : out Wide_String_Access;
			 Result : out Wide_Result_Access);
   
   
   
   
   
   
   
   
   Local_Prefix : constant String := "./";

end Sky.Tools ; 
