-- Skywalker is another attempt of A. i. written with Ada.
-- Skywalker is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := 2024-11-20 19:09:59 ; 
-- Version := 0.10.0r ; 
with Gnat.Os_Lib;
use Gnat.Os_Lib;
with Ada.Wide_Text_Io;

with Sky.Project;
use Sky.Project;
with Sky.Projects_Manager;
use Sky.Projects_Manager;

with Sky.Windows;
with Sky.Classes;

with Sky.Logs;
use Sky.Logs;

with Ada.Calendar;
use Ada.Calendar;
generic
   with package Windows is new Sky.Windows (<>);
package Sky.Walk is
   
   package Classes is new Sky.Classes (Windows.Ansi_Windows);
   
   function System(Cmd : in String) return Integer;
   pragma Import (C, System, "system");
   
   Errno : Integer := 0;
   
   
   package W_Io renames Ada.Wide_Text_Io;
   
   
   
      
   type Abstract_Mode is abstract tagged limited null record;
   
   type All_Mode(Name : Mode_Enum) is new Abstract_Mode with null record;
   
   
   
   type All_Access is access All_Mode'class;
   
   type Mode_Array is array (Natural range <>) of All_Access;
   
   type Application_Record;
   
   task type Console_Process(App : access Application_Record) is
      entry Initialize;
      entry Receive(Wchar : in Wide_Character);
      entry Halt;
      entry Mode(Mode : out Mode_Enum);
      entry Reset;
      entry Switch (Mode : in Mode_Enum);
      entry Set_On_Esc(Is_Escape : in Boolean);      
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
   end Console_Process;
   
   type App_Access is access all Application_Record;
   
   type None_Record(App : App_Access);
   task type None_Process (Mode : access None_Record; App : App_Access) is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Halt;
      entry Suspend;
      entry Wake_Up(Top : in Natural);
      entry Refresh;
      entry Page_Up;
      entry Page_Down;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Full_Screen;

      entry Del;

      entry Begin_Of;

      entry End_Of;
      
      entry Overwrite;

      entry Screen_Print;
      
   end None_Process;
   type None_Record(App : App_Access) is new All_Mode(None) with
      record
	 Proc : None_Process(None_Record'Access, App);	    
      end record;
   
   
   subtype Cpu_String is String (1..6);
   
   Home_Dir : String := Getenv("HOME").all;
   
   task CPU_Process is
      entry Initialize;
      entry Cpu_Get(CPU_Usage : out CPU_String);
      
      entry Halt;
   end CPU_Process;
   
   
   -------------------------------------------------------------
   --                            Log                          --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Log_Record(App : App_Access);
   task type Log_Process (Mode : access Log_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Halt;
   end Log_Process;
   type Log_Record(App : App_Access) is new All_Mode(Log) with
      record
	 Proc : Log_Process(Log_Record'Access, App);
      end record;
   
   -------------------------------------------------------------
   --                            Log                          --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Moneybox_Record(App : App_Access);
   task type MoneyBox_Process (Mode : access MoneyBox_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Refresh;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Full_Screen;
      entry Screen_Print;
      entry Halt;
   end MoneyBox_Process;
   type MoneyBox_Record(App : App_Access) is new All_Mode(Moneybox) with
      record
	 Proc : MoneyBox_Process(MoneyBox_Record'Access, App);
      end record;
   
   -------------------------------------------------------------
   --                            Log                          --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Activity_Record(App : App_Access);
   task type Activity_Process (Mode : access Activity_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Refresh;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Screen_Print;
      entry Halt;
   end Activity_Process;
   type Activity_Record(App : App_Access) is new All_Mode(Activity) with
      record
	 Proc : Activity_Process(Activity_Record'Access, App);
      end record;
   
   
   
   -------------------------------------------------------------
   --                            Log                          --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Stocks_Record(App : App_Access);
   task type Stocks_Process (Mode : access Stocks_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Refresh;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Full_Screen;
      entry Screen_Print;
      entry Halt;
   end Stocks_Process;
   type Stocks_Record(App : App_Access) is new All_Mode(Stocks) with
      record
	 Proc : Stocks_Process(Stocks_Record'Access, App);
      end record;
   
   
   -------------------------------------------------------------
   --                            Log                          --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Bank_Record(App : App_Access);
   task type Bank_Process (Mode : access Bank_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Halt;
   end Bank_Process;
   type Bank_Record(App : App_Access) is new All_Mode(bank) with
      record
	 Proc : Bank_Process(Bank_Record'Access, App);
      end record;
   
   -------------------------------------------------------------
   --                            Log                          --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Planning_Record;
   task type Planning_Process (Mode : access Planning_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Halt;
   end Planning_Process;
   type Planning_Record(App : App_Access) is new All_Mode(Planning) with
      record
	 Proc : Planning_Process(Planning_Record'Access, App);
      end record;

   
   -------------------------------------------------------------
   --                            Log                          --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Library_Record(App : App_Access);
   task type Library_Process (Mode : access Library_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      
      entry Refresh;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Screen_Print;
      entry Halt;
   end Library_Process;
   type Library_Record(App : App_Access) is new All_Mode(Library) with
      record
	 Proc : Library_Process(Library_Record'Access, App);
      end record;
   
   
   -------------------------------------------------------------
   --                         Manager                         --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   type Manager_Record(App : App_Access);
   task type Manager_Process (Mode : access Manager_Record; App : App_Access) is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      
      entry Refresh;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Full_Screen;
      entry Del;
      entry Begin_Of;
      entry End_Of;
      entry Overwrite;
      entry Screen_Print;
      
      entry Halt;
   end Manager_Process;
   type Manager_Record(App : App_Access) is new All_Mode(Manager) with
      record
	 Proc : Manager_Process(Manager_Record'Access, App);
      end record;

   -------------------------------------------------------------
   --                            Log                          --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Contacts_Record(App : App_Access);
   task type Contacts_Process (Mode : access Contacts_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Halt;
   end Contacts_Process;
   type Contacts_Record(App : App_Access) is new All_Mode(Contacts) with
      record
	 Proc : Contacts_Process(Contacts_Record'Access, App);
      end record;
   
   
   -------------------------------------------------------------
   --                            Log                          --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Menu_Record(App : App_Access);
   task type Menu_Process (Mode : access Menu_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Halt;
   end Menu_Process;
   type Menu_Record(App : App_Access) is new All_Mode(Menu) with
      record
	 Proc : Menu_Process(Menu_Record'Access, App);
      end record;
   
   -------------------------------------------------------------
   --                            Log                          --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Organizer_Record(App : App_Access);
   task type Organizer_Process (Mode : access Organizer_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Halt;
   end Organizer_Process;
   type Organizer_Record(App : App_Access) is new All_Mode(Organizer) with
      record
	 Proc : Organizer_Process(Organizer_Record'Access, App);
      end record;

   -------------------------------------------------------------
   --                            Log                          --
   -------------------------------------------------------------
   --                                                         --
   --                                                         --
   --                                                         --   
   
   type Editor_Record(App : App_Access);
   task type Editor_Process (Mode : access Editor_Record; App : App_Access)  is
      --entry Initialize(App : in App_Access);
      entry Receive (Wchar : in Wide_Character);
      entry Wake_Up(Top : in Natural);
      entry Suspend;
      entry Page_Down;
      entry Page_Up;
      entry Up_Arrow;
      entry Down_Arrow;
      entry Left_Arrow;
      entry Right_Arrow;
      entry Begin_Of;
      entry End_Of;
      entry Del;
      entry Overwrite;      
      entry Halt;
   end Editor_Process;
   type Editor_Record(App : App_Access) is new All_Mode(Editor) with
      record
	 Proc : Editor_Process(Editor_Record'Access, App);
      end record;
   
   use Windows;
   
   type Accounting_Windows_Type is
      record
	 Voice_Num_Win     : Window_Record;
	 Acc_Num_Win       : Window_Record;
	 Total_Ht_Win      : Window_Record;
	 Total_TVA_Win     : Window_Record;
	 Total_TTC_Win     : Window_Record;
	 Date_Win          : Window_Record;
	 Peer_Win          : Window_Record;	 
      end record;   
   
   type Ticket_Windows_Type is
      record
	 Line_Num_Win      : Window_Record;
	 Description_Win   : Window_Record;
	 Unit_Ht_Win       : Window_Record;
	 Quantity_Win      : Window_Record;
	 Total_Ht_Win      : Window_Record;
	 TVA_Win           : Window_Record;
	 Total_TVA_Win     : Window_Record;
	 Total_TTC_Win     : Window_Record;
      end record;   
   
   type stock_Windows_Type is
      record
	 stock_Num_Win     : Window_Record;
	 Name_Win          : Window_Record;
	 Quantity_Win      : Window_Record;
	 Unit_Ht_Win       : Window_Record;
	 TVA_Win           : Window_Record;

      end record;   
   
   use Classes;
   
   type Terminal_Type is
      record
	 Root : Abstract_Access;
	 Path : Abstract_Vectors.Vector;
	 Cur  : Abstract_Access;
      end record;
   
   
   
   type Application_Record is limited
      record	 
	 Lines         : Line_Range := 80;
	 Columns       : Column_Range := 320;
	 
	 Term    : Term_Enum := Linux;
	 Desktop : Mode_Array(1..2);
	 Mode    : Mode_Enum := Log;
	 Console : Console_Process(Application_Record'Access);
	 
	 
	 ------------------------------------------------------------
	 --                Project Manager
	 
	 Projects          : Projects_Record(Project_Num_Range'Last);
	 Archives          : Projects_Record(Project_Num_Range'Last);
	 
	 ------------------------------------------------------------
	 --                Activity
	 
	 Activity_Wins     : Accounting_Windows_Type;
	 Initialized       : Boolean := False;
	 
	 ------------------------------------------------------------
	 --                 Stocks
	 
	 Stocks_Wins       : Stock_Windows_Type;
	 
	 ------------------------------------------------------------
	 --                 Money Box
	 
	 Ticket_Wins       : Ticket_Windows_Type;
	 
	 ------------------------------------------------------------
	 --                   Bank
	 
	 --  Accounting_Wins   : Accounting_Windows_Type;
	 
	 ------------------------------------------------------------
	 --                Organizer
	 Terminal : Terminal_Type;
	 
	 Sessions : Session_Array;
	 Logs : Log_Array := (others => (0.0, 0.0));
	 
      end record;
   
   procedure Restore(T : in out Terminal_Type;
   		     Filename : in String);
   
   App : aliased Application_Record;
   Machines : Mode_Array (0..13);
end Sky.Walk ; 
