--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Agnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 20:53:00 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.14.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------

with Ada.Wide_Text_Io;
with Ada.Text_Io;
with Gnat.Command_Line;
use Gnat;
use Ada;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Strings.UTF_Encoding.Strings;
use Ada.Strings.UTF_Encoding.Strings;
with Sky;
use Sky;
package body Gnos.Options is
   
   function Get_Options_From_Command_Line
     -- To get Options_Kit_array_Type from argument in command_line ;
     
     return Options_Kit_Array_Type is
      
      Options_Kit : constant Options_Kit_Array_Type := Full_Line_Options_Kit;
      
   begin
      -- D'abord je traite les arguments de la ligne de commande ;                 --
  Opt :
      loop	 
	 begin
	    loop
	       begin
		  case Command_Line.Getopt ("F: h v n: u: c: V: o: p: e: w: W: l: a: g: s:") is
		     
		     when ASCII.NUL => exit Opt;
			
		     when 'F' =>
			if Command_Line.Full_Switch /= "F" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Options_Kit(Config_Filename).Is_Setted := True;
			Options_Kit(Config_Filename).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));
			
		     when 'h' =>
			if Command_Line.Full_Switch /= "h" then		     
			   raise Command_Line.Invalid_Switch;
			end if;
			Options_Kit(Help).Is_Setted := True;			
		     when 'v' =>
			if Command_Line.Full_Switch /= "v" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Options_Kit(Version_Edition).Is_Setted := True;
		     when 'n' =>
			if Command_Line.Full_Switch /= "n" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Options_Kit(Name_Length).Is_Setted := True;
			Options_Kit(Name_Length).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));
			
		     when 'u' =>
			if Command_Line.Full_Switch /= "u" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Options_Kit(Unit_Max).Is_Setted := True;
			Options_Kit(Unit_Max).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));
			
		     when 'c' =>
			if Command_Line.Full_Switch /= "c" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Options_Kit(Char_Max).Is_Setted := True;
			Options_Kit(Char_Max).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));
		     when 'V' =>
			if Command_Line.Full_Switch /= "V" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Options_Kit(Version).Is_Setted := True;
			Options_Kit(Version).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));
			
		     when 'o' =>
			if Command_Line.Full_Switch /= "o" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Options_Kit(Objects_Max).Is_Setted := True;
			Options_Kit(Objects_Max).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));
		     when 'p' =>
			if Command_Line.Full_Switch /= "p" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Options_Kit(Self_Programming).Is_Setted := True;
			Options_Kit(Self_Programming).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));
		     when 'e' =>
			if Command_Line.Full_Switch /= "e" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Options_Kit(Self_Executed).Is_Setted := True;
			Options_Kit(Self_Executed).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));
		     when 'w' =>
			if Command_Line.Full_Switch /= "w" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Options_Kit(Self_Wait).Is_Setted := True;
			Options_Kit(Self_Wait).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));
		     when 'W' =>
			if Command_Line.Full_Switch /= "W" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Options_Kit(User_Wait).Is_Setted := True;
			Options_Kit(User_Wait).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));
		     when 'l' =>
			if Command_Line.Full_Switch /= "l" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Options_Kit(Lang).Is_Setted := True;
			Options_Kit(Lang).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));
		     when 'g' =>
			if Command_Line.Full_Switch /= "g" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Options_Kit(With_Gtk).Is_Setted := True;
			Options_Kit(With_Gtk).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));
		     when 'a' =>
			if Command_Line.Full_Switch /= "a" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Options_Kit(With_Ada).Is_Setted := True;
			Options_Kit(With_Ada).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));
		     when 's' =>
			if Command_Line.Full_Switch /= "s" then
			   raise Command_Line.Invalid_Switch;
			end if;
			Options_Kit(With_Aws).Is_Setted := True;
			Options_Kit(With_Aws).Value :=
			  new Wide_String ' (To_Wide_String(Decode(Command_Line.Parameter)));
		     
		     when others =>
			raise Program_Error;         -- cannot occur!			
		  end case;
		  
		  
	       exception
		  when Command_Line.Invalid_Switch    => Text_Io.Put_Line ("Invalid Switch " & Command_Line.Full_Switch);
		     
		     raise;
		     
		  when Command_Line.Invalid_Parameter =>
		     
		     raise Spec_Error;
		     		  
	       end;
		  
	    end loop;      
	 exception
	    when Spec_Error =>
	       Text_Io.Put_Line ("No parameter for " & Command_Line.Full_Switch);
	       raise;
	       
	 end;
      end loop opt;
      
      return Options_Kit;
      

      
      
   end Get_Options_From_Command_Line;
   -- return Options_Kit_Array_Type;
   
   
   function Get_Options_From_File
     (Filename : in Wide_String)
     -- To get Options_Kit_array_Type from argument in file ;
     
     return Options_Kit_Array_Type is
      Options_Kit : constant Options_Kit_Array_Type := Full_File_Options_Kit;
      File : Wide_Text_Io.File_Type;
   begin     
      
      Wide_Text_Io.Open(File, Wide_Text_Io.In_File, To_String(Filename));
      while not Wide_Text_Io.End_Of_File(File) loop

	 declare
	    Line   : constant Wide_String := Wide_Text_Io.Get_Line(File);
	    Switch : constant Character := To_Character(Line(Line'First));
	    Parameter : access String;
	 begin
	    
	    if Line'Length > 1 then
	       Parameter := new String ' (To_String(Line(Line'First+1..Line'last)));
	    end if;
	    
	    case Switch is
	       when 'F' =>
		  
		  Options_Kit(Config_Filename).Is_Setted := True;
		  Options_Kit(Config_Filename).Value :=
		    new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
		  
	       when 'h' =>
		  
		  Options_Kit(Help).Is_Setted := True;		  
		  
	       when 'v' =>
		  
		  Options_Kit(Version).Is_Setted := True;

	       when 'n' =>
		  
		  Options_Kit(Name_Length).Is_Setted := True;
		  Options_Kit(Name_Length).Value :=
		    new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
		  
	       when 'u' =>
		  
		  Options_Kit(Unit_Max).Is_Setted := True;
		  Options_Kit(Unit_max).Value :=
		    new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
		  
	       when 'c' =>
		  
		  Options_Kit(Char_max).Is_Setted := True;
		  Options_Kit(Char_max).Value :=
		    new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
	       when 'V' =>
		  
		  Options_Kit(Version).Is_Setted := True;
		  Options_Kit(Version).Value :=
		    new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
		  
	       when 'o' =>
		  
		  Options_Kit(Objects_Max).Is_Setted := True;
		  Options_Kit(Objects_Max).Value :=
		    new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
	       when 'p' =>
		  
		  Options_Kit(Self_Programming).Is_Setted := True;
		  Options_Kit(Self_Programming).Value :=
		    new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
	       when 'e' =>
		  
		  Options_Kit(Self_Executed).Is_Setted := True;
		  Options_Kit(Self_Executed).Value :=
		    new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
	       when 'w' =>
		  
		  Options_Kit(Self_wait).Is_Setted := True;
		  Options_Kit(Self_wait).Value :=
		    new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
	       when 'W' =>
		  
		  Options_Kit(User_wait).Is_Setted := True;
		  Options_Kit(User_wait).Value :=
		    new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
	       when 'l' =>
		  
		  Options_Kit(Lang).Is_Setted := True;
		  Options_Kit(Lang).Value :=
		    new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
	       when 'g' =>
		  
		  Options_Kit(With_Gtk).Is_Setted := True;
		  Options_Kit(With_Gtk).Value :=
		    new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
	       when 'a' =>
		  
		  Options_Kit(With_Ada).Is_Setted := True;
		  Options_Kit(With_Ada).Value :=
		    new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
	       when 's' =>
		  
		  Options_Kit(With_Aws).Is_Setted := True;
		  Options_Kit(With_Aws).Value :=
		    new Wide_String ' (To_Wide_String(Decode(Parameter.all)));
	       when others =>
		  null;
	    end case;

	    
	 end;
      end loop;

      
      
      Wide_Text_Io.Close(File);
     return Options_Kit;
   end Get_Options_From_File;
   -- return Options_Kit_Array_Type;  
   
  
end Gnos.Options;
