--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 19:33:08 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.12.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
with Ada.Calendar;
use Ada.Calendar;

package Gnos.Tools is


   
   function Integer_Image (Value : in Integer) return String;
   
   procedure Difference_In_Years(Top_Date : in Time;
                                 Bot_Date : in Time;
                                 Years    : out Natural;
                                 Months   : out Natural;
                                 Days     : out Natural;
                                 Houres   : out Natural;
                                 Minutes  : out Natural;
                                 Second   : out Natural;
                                 Rest     : out Duration);
   
   function YMD_Elapsed_String(Years    : in Natural;
                           Months   : in Natural;
                           Days     : in Natural) return String;
   
   function Expand_filename (Line : in String) return String;
   
   function Normalize_Quoted_Argument(Arg : in String) return String;
   
   
   
end Gnos.Tools;
