--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 12:44:49 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Authors     : Manuel De Girardi.                                                                                                                         --
-- Version     := 2016.10.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------


with Gnat.Os_Lib;
with Gnat.Directory_Operations;
use Gnat;
with Ada.Text_Io;
use Ada.Text_Io;
use Ada;
with Ada.Calendar;
with Ada.Calendar.Formatting;
use Ada.Calendar.Formatting;
with Ada.Directories;
with Ada.Strings.Unbounded;
use Ada.Strings.Unbounded;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Strings.Fixed;
use Ada.Strings;
with Gnat.Strings;
use Gnat.Strings;


with Gnos.Tools;
package body Gnos.Versions.Editting is
   
   procedure update (Filename : in String; Var_Name : in String; Value : in String) is
      Source : Text_Io.File_Type;
      Target : Text_Io.File_Type;
      
      Tmp_Filename : constant String := Filename & ".tmp";
      Done : Boolean := False;
   begin      
      Text_Io.Put_Line("Change value of " & Var_Name & " to " & Value & " in " & filename & " ; ");

      if Os_Lib.Is_Regular_File(Filename) then

	 Text_Io.Create(Target, Text_Io.Out_File, Tmp_Filename);

	 Text_Io.Open(Source, Text_Io.In_File, Filename);

	 while not Text_Io.End_Of_File(Source) loop
	    declare
	       Line : constant String := Text_Io.Get_Line(Source);
	    begin

	       if not Done then
		  if Fixed.Index(Line, Var_Name) /= 0 then

		     Text_Io.Put_Line(Target, Line(Line'First..Fixed.Index(Line, "=")+1) & Value & " ; ");	       

		     Done := True;
		  else
		     Text_Io.Put_Line(Target, Line);
		  end if;		  

	       else
		  Text_Io.Put_Line(Target, Line);
	       end if;
	    end;
	 end loop;
	 delay 0.2;

	 Text_Io.Close(Target);	 
	 delay 0.2;

	 Text_Io.delete(Source);      	 
	 delay 0.2;

	 directories.Rename(Tmp_Filename, Filename);

      end if;

   end Update;
   
   procedure Replace_Description (Project_Name : in String; Project_Prefix : in String; Var_Name : in String; Value : in String; Node : in String) is
      Filename : constant String := Project_Name & '/' & Project_Prefix & "-" & Node & "/src/lib/" & To_Lower(Project_Prefix) & '-' & To_Lower(Node) & ".ads";
      
      Source : Text_Io.File_Type;
      Target : Text_Io.File_Type;
      
      Tmp_Filename : constant String := Filename & ".tmp";
      Done : Boolean := False;
   begin      
      Text_Io.Put_Line("Change value of " & Var_Name & " to " & Value & " in " & Node & " ; ");
      Text_Io.Put_Line("with filename : " & Filename);
      if Os_Lib.Is_Regular_File(Filename) then
	 Text_Io.Create(Target, Text_Io.Out_File, Tmp_Filename);
	 Text_Io.Open(Source, Text_Io.In_File, Filename);
	 while not Text_Io.End_Of_File(Source) loop
	    declare
	       Line : constant String := Text_Io.Get_Line(Source);
	    begin
	       if not Done then
		  if Fixed.Index(Line, Var_Name) /= 0 then
		     
		     Text_Io.Put_Line(Target, Line(Line'First..Fixed.Index(Line, "=")+1) & Value & " ; ");	       
		     Done := True;
		  else
		     Text_Io.Put_Line(Target, Line);
		  end if;		  
	       else
		  Text_Io.Put_Line(Target, Line);
	       end if;
	    end;
	 end loop;
	 Text_Io.Close(Target);
	 Text_Io.delete(Source);      
	 directories.Rename(Tmp_Filename, Filename);
      end if;
   end Replace_Description;
   
   
   procedure Main_Description (Project_Name : in String; Project_Prefix : in String; Var_Name : in String; Value : in String; Node : in String) is
      Filename : constant String := Project_Name & '/' & Project_Prefix & Node & "/src/" & Project_Name & ".adb";
      Source : Text_Io.File_Type;
      Target : Text_Io.File_Type;
      
      Tmp_Filename : constant String := Filename & ".tmp";
      Done : Boolean := False;
   begin      
      Text_Io.Put_Line("Change value of " & Var_Name & " to " & Value & " in " & Node & " ; ");
      Text_Io.Put_Line("with filename : " & Filename);
      if Os_Lib.Is_Regular_File(Filename) then
	 Text_Io.Create(Target, Text_Io.Out_File, Tmp_Filename);
	 Text_Io.Open(Source, Text_Io.In_File, Filename);
	 while not Text_Io.End_Of_File(Source) loop
	    declare
	       Line : constant String := Text_Io.Get_Line(Source);
	    begin
	       if not Done then
		  if Fixed.Index(Line, Var_Name) /= 0 then
		     
		     Text_Io.Put_Line(Target, Line(Line'First..Fixed.Index(Line, "=")+1) & Value & " ; ");	       
		     Done := True;
		  else
		     Text_Io.Put_Line(Target, Line);
		  end if;		  
	       else
		  Text_Io.Put_Line(Target, Line);
	       end if;
	    end;
	 end loop;
	 Text_Io.Close(Target);
	 Text_Io.delete(Source);      
	 directories.Rename(Tmp_Filename, Filename);
      end if;
   end Main_Description;

   
   procedure To_Major(Project_Name : in String; Project_Prefix : in String) is
   begin
      Replace_Description (Project_Name, Project_Prefix, "Current_Major", Tools.Integer_Image(Version.Major_Version), "versions");
   end To_Major;
   
   procedure To_Minor(Project_Name : in String; Project_Prefix : in String) is
   begin
      Replace_Description (Project_Name, Project_Prefix, "Current_Minor", Tools.Integer_Image(Version.Minor_Version), "versions");
   end To_Minor;
   
   procedure To_Revision(Project_Name : in String; Project_Prefix : in String) is
   begin
      Replace_Description (Project_Name, Project_Prefix, "Current_Revision", Tools.Integer_Image(Version.Revision_Version), "versions");
   end To_Revision;
   
   procedure To_Release(Project_Name : in String; Project_Prefix : in String) is
   begin
      Replace_Description (Project_Name, Project_Prefix, "Current_Release", Character'image(Version.Release_Version), "versions");
   end To_Release;
       
end Gnos.Versions.Editting;
