--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-12-03 00:11:01 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.34.2a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
with Ada.Wide_Text_Io;
--with Ada.Text_Io;
use Ada;
with Gnat.Os_Lib;
use Gnat.Os_Lib;
with Gnat.Command_Line;
use Gnat;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Gnos.Versions;
with Gnos.Versions.Version_Io;
use Gnos.Versions;
package body Gnos.Parameters is
   
   
   procedure All_Parameters(All_Params : in out Gnose_Parameters_Type) is

   begin
      --  Text_Io.Put_Line("Human Lang");
      if Get_Parameter(All_Params.Kit, Human_Lang).Is_Setted then
      	 All_Params.Human_Lang := Human_Lang_Enum'Value(To_String(Get_Parameter(All_Params.Kit, Human_Lang).Value.all));
      end if;
      --  Text_Io.Put_Line("Self wait");
      if Get_Parameter(All_Params.Kit, Self_Wait).Is_Setted then
   	 All_Params.Self_wait := Duration'Value(To_String(Get_Parameter(All_Params.Kit, Self_Wait).Value.all));
      end if;
      --  Text_Io.Put_Line("user wait");
      if Get_Parameter(All_Params.Kit, User_Wait).Is_Setted then
   	 All_Params.User_wait := Duration'Value(To_String(Get_Parameter(All_Params.Kit, User_Wait).Value.all));
      end if;
      --  Text_Io.Put_Line("Programming");
      if Get_Parameter(All_Params.Kit, Self_Programming).Is_Setted then
   	 All_Params.Self_programming := Boolean'Value(To_String(Get_Parameter(All_Params.Kit, Self_Programming).Value.all));
      end if;
      --  Text_Io.Put_Line("Executed");
      if Get_Parameter(All_Params.Kit, Self_Executed).Is_Setted then
   	 All_Params.Self_executed := Boolean'Value(To_String(Get_Parameter(All_Params.Kit, Self_Executed).Value.all));
      end if;
      --  Text_Io.Put_Line("Objects max");
      if Get_Parameter(All_Params.Kit, Object_Max).Is_Setted then
   	 All_Params.Objects_max := Object_Index_Type'Value(To_String(Get_Parameter(All_Params.Kit, Object_Max).Value.all));
      end if;
      --  Text_Io.Put_Line("Char max");
      if Get_Parameter(All_Params.Kit, Char_Max).Is_Setted then
   	 All_Params.Char_Max := Char_Index_type'Value(To_String(Get_Parameter(All_Params.Kit, Char_Max).Value.all));
      end if;
      --  Text_Io.Put_Line("Version");
      if Get_Parameter(All_Params.Kit, Version).Is_Setted then
   	 All_Params.Version := Version_Index_type'Value(To_String(Get_Parameter(All_Params.Kit, Version).Value.all));
      end if;
      --  Text_Io.Put_Line("Name length");
      if Get_Parameter(All_Params.Kit, Name_Length).Is_Setted then
   	 All_Params.Name_Length := Positive'Value(To_String(Get_Parameter(All_Params.Kit, Name_Length).Value.all));
      end if;
      --  Text_Io.Put_Line("unit max");
      if Get_Parameter(All_Params.Kit, Unit_Max).Is_Setted then
   	 All_Params.Unit_Max := Positive'Value(To_String(Get_Parameter(All_Params.Kit, Unit_Max).Value.all));
      end if;
      --  Text_Io.Put_Line("Gtk");
      if Get_Parameter(All_Params.Kit, With_Gtk).Is_Setted then
   	 All_Params.With_Gtk := Boolean'Value(To_String(Get_Parameter(All_Params.Kit, With_Gtk).Value.all));
      end if;
      --  Text_Io.Put_Line("Ada");
      if Get_Parameter(All_Params.Kit, With_Ada).Is_Setted then
   	 All_Params.With_Ada := Boolean'Value(To_String(Get_Parameter(All_Params.Kit, With_Ada).Value.all));
      end if;
      --  Text_Io.Put_Line("Aws");
      if Get_Parameter(All_Params.Kit, With_Aws).Is_Setted then
   	 All_Params.With_Aws := Boolean'Value(To_String(Get_Parameter(All_Params.Kit, With_Aws).Value.all));
      end if;            
      
   end All_Parameters;
   
   
   procedure Print_Parameters (Kit : in Parameters_Kit_Array_Type) is
   begin
      for Parameter_Flag in Parameters_Flags_Enum_Type'range loop
	 
	 case Parameter_Flag is
	    
	    when Null_Parameter =>
	       
	       null;
	    when others =>
	       
	       if kit(Parameter_Flag).Is_Setted and
		 
		 kit(Parameter_Flag).Requiered_Parameter  then
		  
		  
		  declare
		     Parameter : constant Wide_String := 
		       kit(Parameters_Flags_Enum_Type'Val(Parameters_Flags_Enum_Type'Pos(Parameter_Flag))).Value.all;
		  begin
		     Wide_Text_Io.Put_Line
		       (To_Wide_String
			  (
			   Parameters_Flags_Enum_Type'Image(Parameter_Flag)) &
			  " setted with parameter : " & 
			  "" & Parameter & "" & " ; ");
		  end;
	       elsif  kit(Parameter_Flag).Is_Setted then		  
		  Wide_Text_Io.Put_Line
		    (To_Wide_String(Parameters_Flags_Enum_Type'Image(Parameter_Flag)) &
		       " setted without parameter.");		  
	       end if;
	 end case;
	 
      end loop;
   end Print_Parameters;
   
   
   procedure Set_Parameters(The_Parameters : out Parameters_Kit_Record;			    
			    Options_Kit : in Options_Kit_Array_Type) is
     

     
      
   begin
     
      ------------------------------------------------------------------
      --                                                              --
      -- Initilaisation des parametres depuis les options.            --
      --                                                              --
      ------------------------------------------------------------------
      for Option_Flag in Optionals_Flags_Enum_Type'range loop
	 
	 case Option_Flag is
	    
	    when Null_Option =>
	       
	       null;
	    when others =>
	       
	       The_Parameters.kit
		 
		 (
		  
		  Parameters_Flags_Enum_Type'Val
		    
		    (
		     
		     Optionals_Flags_Enum_Type'Pos(Option_Flag)
		       
		    )
		    
		 ).Is_Setted := 
		 
		 Options_Kit(Option_Flag).Is_Setted;
	       
	       	       
	       if Options_Kit(Option_Flag).Is_Setted and
		 
		 Options_Kit(Option_Flag).Requiered_Parameter  then
		  
		  The_Parameters.Kit
		    
		    (
		     
		     Parameters_Flags_Enum_Type'Val
		       
		       (
			
			Optionals_Flags_Enum_Type'Pos(Option_Flag)
			  
		       )
		       
		    ).Value :=
		    
		    new Wide_String ' 
		    
		    (
		     
		     Options_Kit(Option_Flag).Value.all
		       
		    );
	       end if;
	       
	 end case;
	 
      end loop;
                 
   end Set_Parameters;
   

   
   function Set_Parameters_From
     
     (Filename : in Wide_String) 
     
     return Parameters_Kit_Record is
      
      Parameters_Kit : Parameters_Kit_Record :=

	(Kit => File_Parameters);
      
      
      Options_Kit : access Options_Kit_Array_Type;	   
                  
   begin
      Options_Kit := new Options_Kit_Array_Type ' (Get_Options_From_File(filename));      
      Set_Parameters(Parameters_Kit, Options_Kit.All);
      return Parameters_Kit;
   end Set_Parameters_From;
   
   function Get_Parameter
     (From : in Parameters_Kit_Array_Type;
      Flag : in Parameters_Flags_Enum_Type)
     return Parameter_Tagged_Record_Type is
   begin
      return From(Flag).all;
   end Get_Parameter;
   
   procedure Parameters_Descriptions
     (From : in Parameters_Kit_Array_Type) is
   begin
      Wide_Text_Io.Put_Line("Help: gnostic [ Options [ Parameters ] ]");
      Wide_Text_Io.Put_Line("Help: Options : ");
      for Parameter_Flag in Config_filename..Parameters_Flags_Enum_Type'Last loop
	 declare
	    Parameter : constant Parameter_Tagged_Record_Type :=
	      Get_Parameter(From, Parameter_flag);
	 begin	    
	    if Parameter.Switch /= null then
	       Wide_Text_Io.Put('-' & Parameter.Switch.all & " : ");
	    end if;
	    if Parameter.Descr /= null then
	       Wide_Text_Io.Put(Parameter.Descr.all & " => ");
	    end if;
	    if Parameter.Requiered_Parameter then
	      if Parameter.param /= null then
	       Wide_Text_Io.Put(Parameter.Param.all);
	      end if;
	    end if;
	 end;
	 Wide_Text_Io.New_Line;
      end loop;
   end Parameters_Descriptions;
   
   
   procedure initialize(Gnose_Parameters : in out Gnose_Parameters_Type; End_Of_Task : out boolean) is

      
      Options_Kit : access Options_Kit_Array_Type;	   
      
      Help_Parameter : Parameter_Tagged_Record_Type(False);      
      
   begin
      
	End_Of_Task := False;
      
      begin
	 
	 Options_Kit := new Options_Kit_Array_Type ' (Get_Options_From_Command_Line);

	 case Options_Kit(Config_Filename).Is_Setted is
	    when False =>
	       if Is_Regular_File("Config_File.txt") then
		  Gnose_Parameters.Kit := Set_Parameters_from("Config_File.txt").kit;
	       else
		  Gnose_Parameters.kit := File_Parameters;
	       end if;
	    when True =>
	       Parameters_Kit_Record(Gnose_Parameters) := Set_Parameters_from(Options_Kit(Config_Filename).Value.all);
	 end case;
	 declare
	    All_Parameters_Kit : Parameters_Kit_Record := (Kit => Line_Parameters);
	 begin
	    
	    Set_Parameters(All_Parameters_Kit, Options_Kit.all);
	    for Parameter_Id in Parameters_Flags_Enum_Type'Val(1) ..Parameters_Flags_Enum_Type'last  loop
	       if All_Parameters_Kit.Kit(Parameter_Id).Is_Setted then		  
	    	  Gnose_Parameters.Kit(Parameter_Id).all := 
	    	    All_Parameters_Kit.Kit(Parameter_Id).all;
	       end if;
	    end loop;	    
	 end;
	 
	 All_Parameters(Gnose_Parameters);
	 
	 
	 case Get_Parameter(Gnose_Parameters.kit, Version_Edition).Is_Setted is
	    when False =>
	       null;
	    when True =>	    
	       Wide_Text_Io.Put_Line(To_Wide_String(Gnos.Versions.Version_Io.To_String(Gnos.Versions.Version)));
	       End_Of_Task := True;
	 end case;
	 
	 Help_Parameter :=
	   Get_Parameter(Gnose_Parameters.kit, Help);
	 
	 if Help_Parameter.Is_Setted then
	    Parameters_Descriptions(Gnose_Parameters.Kit);
	    End_Of_Task := True;
	 end if;	 	 
	 
	 
      exception      
	 when Command_Line.Invalid_Parameter =>
	    Wide_Text_Io.Put_Line("Exception in initialization of ");
	 raise;	 
	 when others =>
	    Wide_Text_Io.Put_Line("Exception in initialization of ");
	    raise;
      
      end;
                        
   end initialize;
   
   
end Gnos.Parameters;
