--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 19:33:08 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.12.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
with Gnos.Parameters;
with Gnos.Objects;
generic
   Params : Parameters.System_Parameters_Type;
   
package Gnos.Systems is
   use Parameters;
   Objects_Params : constant Objects_Parameters_Type := Objects_Parameters_Type(params);
   package Objects_system is new Gnos.Objects(Objects_Params);
   
   System_Params : Parameters.System_Parameters_Type := Params;
   
   use Objects_System;
   use Objects_System.Name_8;
   use Objects_System.Name_12;
   use Objects_System.Name_16;
   use Objects_system.Language;
   use Objects_system.Language.Agnose_Projects;

   function Random_name(char_index : in char_index_type) return string;

   type System_Context_Record is new Objects_System.Objects_Context_record with
     
      record 
	 System_Params : Parameters.System_Parameters_Type := Systems.System_Params;
      end record;
   
   
   procedure initialize(System_Context : in out System_Context_Record;
			System_Params  : in System_Parameters_Type);
   procedure Load_Project(System_Context : in out System_Context_Record;			
			Ada_Path : in String;
			Gtk_Path : in String;
			Aws_Path : in String;
			Project_Path : in String);
   
   function Check_Parameters(System_Context : in System_Context_Record'Class;
			    Params : in System_Parameters_Type'class) return Boolean;
   
   
   type System_record is new Objects_System.Objects_system with
      record
	 null;
      end record;
end Gnos.Systems;

