with Gtk.Paned;                         use Gtk.Paned;
with Gtk.Frame;                         use Gtk.Frame;
with Gtk.Tree_Model;                    use Gtk.Tree_Model;
with Gtk.Tree_View;                     use Gtk.Tree_View;
with Gtk.Tree_Store;                    use Gtk.Tree_Store;

with Gtk.Gentry ;                       use Gtk.Gentry;
with Gtk.Check_Button;                  use Gtk.Check_Button;
with Gtk.Label;                         use Gtk.Label;

with Gtk.Combo_Box_Text;                use Gtk.Combo_Box_Text;
with Gtk.Button;                        use Gtk.Button;
with Gtk.Spin_Button;                   use Gtk.Spin_Button;

with Libsens.Processing.Main;           use Libsens.Processing.Main;


with Glib;
with Glib.Main;                         use Glib.Main;
with GtkAda.Application;                use GtkAda.Application;
with Gtk.Application_Window;            use Gtk.Application_Window;
with Gtk.Window;                        use Gtk.Window;
with Gtk.Box;                           use Gtk.Box;
with System.Address_To_Access_Conversions;
with Ada.Unchecked_Deallocation;

with Gtk.Action_Group;
pragma Elaborate_All(Gtk.Action_Group);
use Gtk.Action_Group;

with Gtk.UI_Manager;                    use Gtk.UI_Manager;



with Libsens.Virtual;                   use Libsens.Virtual;
with Libsens.Virtual.Work_Class;        use Libsens.Virtual.Work_Class;


with Libsens.Gtk_Plugins_Specifications;use Libsens.Gtk_Plugins_Specifications;
with Libsens.Applications.Main;         use Libsens.Applications.Main;

package Libsens.Applications.Gm_Interface is
   type Gm_Interface_Record;
         
   type Gm_Interface_Access is access all Gm_Interface_Record;
   
   type Plugin_Page_Access is access all Plugin_Page_Type;
   
   type Plugins_Pages_Set is array (Plugin_num'range) of Plugin_Page_Access;
   
   
   type Plugin_Info_Record is tagged
      record	 	 
	 
	 Id            : Plugin_Num := 1;
	 
	 Edit_Button   : Gtk_Check_Button;
	 Id_Label      : Gtk_Label;
	 
	 Mutted        : Gtk_Check_Button;
	 
	 Device_Id     : Gtk_Combo_Box_Text;
	 Device_Label  : Gtk_Label;
	 
	 Channel_Id    : Gtk_Combo_Box_Text;
	 Channel_Label : Gtk_Label;
	 
	 Form_Id       : Gtk_Combo_Box_Text;
	 Form_Label    : Gtk_Label;
	 
	 Cat_Id        : Gtk_Combo_Box_Text;
	 Cat_Label     : Gtk_Label;
	 
	 Info_Box      : Gtk_Hbox;
      end record;
	 
	 
   type Plugin_Info_Access is access all Plugin_Info_Record;
   
   type Plugin_Array is array (Plugin_Num'Range) of Plugin_Info_Access;
   
   
   type Work_Window_Record (Work : Work_Access;			   
			    Work_Id : Work_Num;
			    Int     : Gm_Interface_Access) is
      record	 
	 Win                :  Gtk_Window;
	 Title              : access String;	 
	 Main_Vbox          : Gtk_Vbox;	   
	 
	 
	 Menus_Hbox         : Gtk_Hbox;
	 
	 App_Action_Group   : Gtk_Action_Group;
	 App_UI             : Gtk_UI_Manager;
	 Win_Action_Group   : Gtk_Action_Group;
	 Win_UI             : Gtk_UI_Manager;
	 
	 
	 Process                     : Work_Processing_Access;
	 
	 Master_Frame                : Gtk_Frame;
	 Master_Box                  : Gtk_Box;
	 Signature                   : Gtk_Entry;
	 Tempo_Button                : Gtk_Spin_Button;
	 Track_length_Button         : Gtk_Spin_Button;
	 Played_Form                 : Gtk_Combo_Box_Text;
	 
	 Flow_Frame                  : Gtk_Frame;	 
	 Flow_Model                  : Gtk_Tree_Store;
	 Flow_Tree                   : Gtk_Tree_View;
	 Iter                        : Gtk_Tree_Iter;   
	 Line_Counter                : Natural := 0;
	 
	 Devices_Frame               : Gtk_Frame;
	 Devices_Model               : Gtk_Tree_Store;
	 Devices_Tree                : Gtk_Tree_View;
	 
	 Plugins_Frame               : Gtk_Frame;
	 Plugins_Model               : Gtk_Tree_Store;
	 Plugins_Tree                : Gtk_Tree_View;
	 Plugins_List                : Plugin_Array;
	 Plugins_Pages               : Plugins_Pages_Set;-- := (others => new Plugin_Page_Type);
	 
	 Flow_Paned                  : Gtk_Hpaned;	 
	 
	 Main_Paned                  : Gtk_Vpaned;
	 
	 State_Frame                 : Gtk_Frame;
	 State_Box                   : Gtk_Hbox;	 	 
	 Media_Play                  : Gtk_Button;
	 Media_Stop                  : Gtk_Button;
	 In_Loop                     : Gtk_Check_Button;	 
	 Elapsed                     : Gtk_Entry;	 	 
	 Position                    : Gtk_Entry;
	 State_Vbox                  : Gtk_Box;
	 Tools_Box                   : Gtk_Box;            
	 State_Label                 : Gtk_Label;            
	 Modulation_Play_On          : Gtk_Button;
	 Modulation_Play_Off         : Gtk_Button;
	 Modulation_Record_On        : Gtk_Button;
	 Modulation_Record_Off       : Gtk_Button;            
	 Mod_Reset                   : Gtk_Button;
      	 
	 
	 Main_Hbox                   : Gtk_Hbox;	 
	 
	 	 
	 Flow_Control                : Glib.Main.G_Source_Id :=
	   Glib.Main.No_Source_Id;
	 State_Control               : Glib.Main.G_Source_Id :=
	   Glib.Main.No_Source_Id;
   
	 
      end record;
   
   package Work_Window_Conversions
   is new System.Address_To_Access_Conversions
     (Work_Window_Record);
   
   subtype Work_Window_Pointer is Work_Window_Conversions.Object_Pointer;
   
   type Work_Window_Array is array (Work_num range <>) of Work_Window_Pointer;
   
   
   type Gm_Interface_Record is new Virtual_MIDI_Composer with
      record
	 App        : GtkAda_Application;
	 
	 Win        : Gtk_Application_Window;	 
	 Works_Win  : Work_Window_Array(1..128);
	 Win_Cur    : Work_num := 1;
	 Work_Last  : natural := 0; 
	 
	 Main_Automation  : G_Source_Id;
      end record;
     
   package GM_Interface_Conversions
   is new System.Address_To_Access_Conversions
     (Gm_Interface_Record);
   
   subtype Gm_Interface_Pointer
      is GM_Interface_Conversions.Object_Pointer;
   
   procedure Initialize(Gm_Interface : in out Gm_Interface_Pointer;
			State : out Glib.Gint;
			Works : access Work_Array;
			Verbose, Auto_Play, In_Loop, Help, Ignore : in Boolean);
   
private   
   
   procedure Free is new Ada.Unchecked_Deallocation(Work_Window_Record, Work_Window_Pointer);   
   
   procedure Free is new Ada.Unchecked_Deallocation(Gm_Interface_Record, Gm_Interface_Pointer);   
   
   GApplication_Id : constant String := "libsens.applications.gm_interface";
   
   package Main_Sources is new Glib.Main.Generic_Sources(Gm_Interface_Pointer);
end Libsens.Applications.Gm_Interface;
