
with Libsens.Common;                    use Libsens.Common;

package Libsens.Data.Drums is
   pragma Elaborate_Body;
   
   
   subtype Drums_Value_type is Value_Type range 36..51;   
                 
   subtype Drums_Sentence_Type is Sentence_type (Drums_Value_Type);
   
   Rime : constant Word16_Type := 16#0100#;
   Hat_Roll : constant Word16_Type := 16#0101#;
   function Tribe(Den : in Den_Type) return Word16_Type;
   function Rand(Den : in Den_Type; Length : in Positive) return Word16_Type;
   
   
   
   task Drums_Gen is
      pragma Storage_size(8388608);      
      entry Initialize(Filename : in String; Reuse : in Boolean; Converged : in Float; Max_Epochs : in Positive);
      
      entry Respond(Filename : in String; Channel : in Channel_Type; Seq : in out Seq_Vectors.Vector);
      
      entry Halt;
   end Drums_Gen;
   
end Libsens.Data.Drums;
