with Ada.Text_Io;
use Ada;



package body Libsens.Data is
   
   use Step_Vectors;
   
   function Beat(Word16 : in Word16_Type; Index : in Natural) return Boolean is
   begin
      return (Word16 and 2**(Index mod 16)) > 0;
   end Beat;
   
   
   type Step_Seq_Type is array (0..15) of Step_Vectors.Vector;
   
   procedure Pattern(From : in Sentence_Type; Channel : in Channel_Type; Seq : in out  Seq_Vectors.Vector) is
      Step_Seq : Step_Seq_Type;
   begin
      for I in 1..Seq_Vectors.Last_Index(Seq) loop
	 Step_Seq(I) := Seq_Vectors.Element(Seq, I);
	 exit when I = Step_Seq'Last;
      end loop;
            
      for I in Step_Seq'range loop
	 for J in From'Range loop
	    if Beat(From(J).Sentence, I) then
	       
	       Step_Seq(I) := Step_Seq(I) & 
		 To_Long(Note_On(Channel, From(J).key, From(J).sens));	       
	       
	       Step_Seq(Integer'Min(Integer(I+Integer(From(J).Length)) mod (Step_Seq'Length-1), Integer(Step_Seq'Last))) := 
		 Step_Seq(Integer'Min(Integer(I+Integer(From(J).Length)) mod (Step_Seq'length-1), Integer(Step_Seq'Last))) & To_Long(Note_Off(Channel, From(J).key));
	       
	    end if;
	 end loop;
      end loop;
      Seq := Seq_Vectors.Empty_Vector;
      for I in Step_Seq_Type'Range loop
	 Seq := Seq_Vectors."&"(Seq, Step_Seq(I));
	 
      end loop;

   end Pattern;      
   
end Libsens.Data;
