with Gtk.Frame;                         use Gtk.Frame;
with Gtk.Label;                         use Gtk.Label;
with Gtk.Box;                           use Gtk.Box;
with Gtk.Spin_Button;                   use Gtk.Spin_Button;
with Gtk.Check_Button;                  use Gtk.Check_Button;
with Gtk.GEntry;                        use Gtk.GEntry;
with Gtk.Button;                        use Gtk.Button;
with Gtk.Combo_Box_Text;                use Gtk.Combo_Box_Text;

with Gtkada.File_Selection;             use Gtkada.File_Selection;

with Libsens.Common;                    use Libsens.Common;

with Libsens.Virtual;                   use Libsens.Virtual;
with Libsens.Virtual.Arp_Sequencer;     use Libsens.Virtual.Arp_Sequencer;
with Libsens.Virtual.Work_Class;        use Libsens.Virtual.Work_Class;
  
with Libsens.Gtk_Plugins_Specifications;use Libsens.Gtk_Plugins_Specifications;

package Libsens.Gtk_Arpegiator is
   
   type GTK_Note is tagged
      record
         Note_Vbox          : Gtk_Vbox;         
         Key_Spin_Button    : Gtk_Spin_Button;
         Sens_Spin_button   : Gtk_Spin_Button;	 
      end record;

   type Gtk_Note_Access is access all GTK_Note;

   type GTK_Note_Table is array (Positive range <>) of Gtk_Note_Access;
         
   procedure Initialize
     (Note : in out Gtk_Note_Access;      
      The_note : in note_Access;
      Plugin : in Abstract_Plugin_Access);


   type GTK_Step is tagged
      record
         Step_Vbox        : Gtk_Vbox;
         Step_Label       : Gtk_Label;         
         Set_Check_button : Gtk_Check_Button;	 
	 Length_Spin_button : Gtk_Spin_Button;
      end record;
   
   
   type Gtk_Step_Access is access all GTK_Step;
   
   procedure Init_step
     (Step : in out Gtk_Step_Access;
      The_Step : in step_Access;
      Label : in String;
      Plugin : in Abstract_Plugin_Access);
   

   type GTK_Step_Table is array (Positive range <>) of Gtk_Step_Access;
   

   type GTK_Intelligence is tagged
      record
	 Network_Parameters    : Gtk_Vbox;
         Filename_Label        : Gtk_Label;
         Filename_Gentry       : Gtk_Gentry;
         File_Selection_button : Gtk_Button;
         --File_Selection        : Gtkada_File_Selection;
	 
	 Reuse             : Gtk_Combo_Box_text;	 
	 Converged         : Gtk_Spin_Button;	 
         Max_Epoch         : Gtk_Spin_Button;	 
	 
	 Last_Label            : Gtk_Label;
	 --
         Last_Spin_Button      : Gtk_Spin_Button;
         Transpose_Label       : Gtk_Label;
         --
         Transpose_Spin_Button : Gtk_Spin_Button;

	 Resolution            : Gtk_Combo_Box_text;
	 
	 
	 
	 
	 
         Main_Frame            : Gtk_Frame;
         --
         Main_Vbox             : Gtk_Vbox;
         Main_Hbox             : Gtk_Hbox;
         Parameters            : Gtk_Vbox;
         Key_Label             : Gtk_Label;
         Sens_Label            : Gtk_Label;
         Label_Vbox            : Gtk_Vbox;
         --
	 Chord                 : GTK_Note_Table(1..3);
         Chord_Hbox            : Gtk_Hbox;

         
         Step_Table            : Gtk_Step_Table(1..32);
         Stepseq_Hbox          : Gtk_Hbox;
         Step_Parameters       : Gtk_Vbox;
	 
	 
      end record;

   type Intelligence_Access is access all Gtk_Intelligence;

   procedure Init_intel
     (Intelligence : out Intelligence_Access;
     Plugin : in Abstract_Plugin_access);  
   
   type Arpegiator_Specifications is
     new Abstract_Plugin_Specifications(Arp_Seq) with
      record	 
	 Intel : Intelligence_Access;
      end record;
   
   
   procedure Initialize (Spec : in out Arpegiator_Specifications;
     			 Plugin : in Abstract_Plugin_Access);
   
end Libsens.Gtk_Arpegiator;
