
with Glib;                              use Glib;
with Gtk.Handlers;                      use Gtk.Handlers;
pragma Elaborate_All (Gtk.Handlers);
with Gtk.Widget;                        use Gtk.Widget;
with Gtk.Enums;                         use Gtk.Enums;
with Gtk.Frame;                         use Gtk.Frame;
with Gtk.Box;                           use Gtk.Box;
with Gtk.Label;                         use Gtk.Label;

with Libsens.Virtual.Gen_plugin;        use Libsens.Virtual.Gen_Plugin;

with Text_Io;                           use Text_Io;

package body Libsens.Gtk_Genetical is
   
   ----------------------
   -- genetical plugin --
   ----------------------         
   
   package Plugin_Cb is new Gtk.Handlers.User_Callback 
     (Gtk.Widget.Gtk_Widget_Record, 
      Abstract_Plugin_Access);
   
   
   
   procedure Max_B_Inf_Bass_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Bass_Plugin_Record(Plugin.all).Max_B_Inf := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Max_B_Inf_Bass_Callback;
   
   procedure Max_B_Sup_Bass_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Bass_Plugin_Record(Plugin.all).Max_B_Sup := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Max_B_Sup_Bass_Callback;
   
   
   procedure Min_Class_Id_Bass_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Bass_Plugin_Record(Plugin.all).Min_Class_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Min_Class_Id_Bass_Callback;
   
   procedure Max_Class_Id_Bass_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Bass_Plugin_Record(Plugin.all).Max_Class_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Max_Class_Id_Bass_Callback;

   
   procedure Min_Value_Id_Bass_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Bass_Plugin_Record(Plugin.all).Min_Value_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Min_Value_Id_Bass_Callback;
   
   procedure Max_Value_Id_Bass_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Bass_Plugin_Record(Plugin.all).Max_Value_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Max_Value_Id_Bass_Callback;
   
   procedure Min_Data_Id_Bass_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Bass_Plugin_Record(Plugin.all).Min_Data_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Min_Data_Id_Bass_Callback;
   
   procedure Max_Data_Id_Bass_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Bass_Plugin_Record(Plugin.all).Max_Data_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Max_Data_Id_Bass_Callback;

   
            
   procedure Initialize (Spec : in out Genetical_Bass_Specifications;
     			 Plugin : in Abstract_Plugin_access) is
      
      
      Vbox : Gtk_Vbox;
      Label : Gtk_Label;
      Hbox : Gtk_Hbox;
   begin
            
      Gtk_New(Spec.Specifications_Frame, "Genetical bass : ");      
      
      Gtk_New_Vbox(Vbox, Homogeneous => False);
      
      Put_Line("Genetical bass :  0.0.0");
      Gtk_New(Spec.Config.Max_B_inf, 1.0, 1.0, 1.0);
      --Put_Line("Genetical bass :  0.1.0");
      Set_Value(Spec.Config.Max_B_inf, Gdouble(Gen_Bass_Plugin_Record(Plugin.all).Max_B_Inf));
      --Put_Line("Genetical bass :  0.2.0");
      Gtk_New_Hbox(Hbox);      
      Gtk_New(Label, "Frame b_inf  (has constant 1 : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Max_B_Inf, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
      --Put_Line("Genetical bass :  0.0.1");
      Plugin_Cb.Connect
        (Spec.config.Max_B_Inf, "value_changed", Plugin_Cb.To_Marshaller(Max_B_inf_Bass_Callback'Access),
	 User_Data => Plugin);
      --Put_Line("Genetical bass :  0.0.2");
      Gtk_New(Spec.Config.Max_B_Sup, 1.0, 4.0, 1.0);
      Set_Value(Spec.Config.Max_B_Sup, Gdouble(Gen_Bass_Plugin_Record(Plugin.all).Max_B_Sup));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame b_Sup (has max element)  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Max_B_Sup, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
      --Put_Line("Genetical bass :  0.0.3");
      Plugin_Cb.Connect
        (Spec.config.Max_B_Sup, "value_changed", Plugin_Cb.To_Marshaller(Max_B_Sup_Bass_Callback'Access),
	 User_Data => Plugin);
      --Put_Line("Genetical bass :  0.0.4");
      Gtk_New(Spec.Config.Min_Class_Id, 5.0, 63.0, 1.0);
      Set_Value(Spec.Config.Min_Class_Id, Gdouble(Gen_Bass_Plugin_Record(Plugin.all).Min_Class_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame min class id (has key type)  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Min_Class_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
      --Put_Line("Genetical bass :  0.0.5");
      Plugin_Cb.Connect
        (Spec.config.Min_Class_Id, "value_changed", Plugin_Cb.To_Marshaller(Min_Class_Id_Bass_Callback'Access),
	 User_Data => Plugin);
      --Put_Line("Genetical bass :  0.0.6");
      Gtk_New(Spec.Config.Max_Class_Id, 24.0, 65.0, 1.0);
      Set_Value(Spec.Config.Max_Class_Id, Gdouble(Gen_Bass_Plugin_Record(Plugin.all).Max_Class_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame max class id (has key type)  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Max_Class_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
      --Put_Line("Genetical bass :  0.0.7");
      Plugin_Cb.Connect
        (Spec.config.Max_Class_Id, "value_changed", Plugin_Cb.To_Marshaller(Max_Class_Id_Bass_Callback'Access),
	 User_Data => Plugin);
      --Put_Line("Genetical bass :  0.0.8");
      
      Gtk_New(Spec.Config.Min_Value_Id, 25.0, 65.0, 1.0);
      Set_Value(Spec.Config.Min_Value_Id, Gdouble(Gen_Bass_Plugin_Record(Plugin.all).Min_Value_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame min Value id  (has sens type) : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Min_Value_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
      --Put_Line("Genetical bass :  0.0.9");
      Plugin_Cb.Connect
        (Spec.config.Min_Value_Id, "value_changed", Plugin_Cb.To_Marshaller(Min_Value_Id_Bass_Callback'Access),
	 User_Data => Plugin);
      --Put_Line("Genetical bass :  0.0.10");
      Gtk_New(Spec.Config.Max_Value_Id, 29.0, 127.0, 1.0);
      Set_Value(Spec.Config.Max_Value_Id, Gdouble(Gen_Bass_Plugin_Record(Plugin.all).Max_Value_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame max Value id (has sens type)  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Max_Value_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
      --Put_Line("Genetical bass :  0.0.11");
      Plugin_Cb.Connect
        (Spec.config.Max_Value_Id, "value_changed", Plugin_Cb.To_Marshaller(Max_Value_Id_Bass_Callback'Access),
	 User_Data => Plugin);
      
      Gtk_New(Spec.Config.Min_Data_Id, 2.0, 64.0, 1.0);
      Set_Value(Spec.Config.Min_Data_Id, Gdouble(Gen_Bass_Plugin_Record(Plugin.all).Min_Data_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame min Data id (has length type  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Min_Data_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
      --Put_Line("Genetical bass :  0.0.12");
      Plugin_Cb.Connect
        (Spec.config.Min_Data_Id, "value_changed", Plugin_Cb.To_Marshaller(Min_Data_Id_Bass_Callback'Access),
	 User_Data => Plugin);
      --Put_Line("Genetical bass :  0.0.13");
      Gtk_New(Spec.Config.Max_Data_Id, 6.0, 127.0, 1.0);
      Set_Value(Spec.Config.Max_Data_Id, Gdouble(Gen_Bass_Plugin_Record(Plugin.all).Max_Data_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame max Data id (has length type)  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Max_Data_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
      --Put_Line("Genetical bass :  0.0.14");
      Plugin_Cb.Connect
        (Spec.config.Max_Data_Id, "value_changed", Plugin_Cb.To_Marshaller(Max_Data_Id_Bass_Callback'Access),
	 User_Data => Plugin);
      --Put_Line("Genetical bass :  0.0.15");
      
      
      Add (Spec.Specifications_Frame, Vbox);
      
      
      --Put_Line("Load seq 0.1.8.1");
      
   end Initialize;
   
   procedure Max_B_Inf_Synth_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Synth_Plugin_Record(Plugin.all).Max_B_Inf := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Max_B_Inf_Synth_Callback;
   
   procedure Max_B_Sup_Synth_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Synth_Plugin_Record(Plugin.all).Max_B_Sup := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Max_B_Sup_Synth_Callback;
   
   
   procedure Min_Class_Id_Synth_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Synth_Plugin_Record(Plugin.all).Min_Class_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Min_Class_Id_Synth_Callback;
   
   procedure Max_Class_Id_Synth_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Synth_Plugin_Record(Plugin.all).Max_Class_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Max_Class_Id_Synth_Callback;

   
   procedure Min_Value_Id_Synth_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Synth_Plugin_Record(Plugin.all).Min_Value_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Min_Value_Id_Synth_Callback;
   
   procedure Max_Value_Id_Synth_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Synth_Plugin_Record(Plugin.all).Max_Value_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Max_Value_Id_Synth_Callback;
   
   procedure Min_Data_Id_Synth_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Synth_Plugin_Record(Plugin.all).Min_Data_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Min_Data_Id_Synth_Callback;
   
   procedure Max_Data_Id_Synth_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Synth_Plugin_Record(Plugin.all).Max_Data_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Max_Data_Id_Synth_Callback;

   
   
   procedure Initialize (Spec : in out Genetical_Synth_Specifications;
     			 Plugin : in Abstract_Plugin_access) is
      
      
      Vbox : Gtk_Vbox;
      Label : Gtk_Label;
      Hbox : Gtk_Hbox;
   begin
      
      
      
      Gtk_New(Spec.Specifications_Frame, "Genetical synth : ");      
      
      Gtk_New_Vbox(Vbox, Homogeneous => False);
      
      Gtk_New(Spec.Config.Max_B_inf, 1.0, 1.0, 1.0);
      Set_Value(Spec.Config.Max_B_inf, Gdouble(Gen_Synth_Plugin_Record(Plugin.all).Max_B_Inf));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame b_inf (has constant 1  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Max_B_Inf, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
            
      Plugin_Cb.Connect
        (Spec.config.Max_B_Inf, "value_changed", Plugin_Cb.To_Marshaller(Max_B_inf_Synth_Callback'Access),
	 User_Data => Plugin);
      
      Gtk_New(Spec.Config.Max_B_Sup, 1.0, 4.0, 1.0);
      Set_Value(Spec.Config.Max_B_Sup, Gdouble(Gen_Synth_Plugin_Record(Plugin.all).Max_B_Sup));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame b_Sup (has max element)  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Max_B_Sup, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
            
      Plugin_Cb.Connect
        (Spec.config.Max_B_Sup, "value_changed", Plugin_Cb.To_Marshaller(Max_B_Sup_Synth_Callback'Access),
	 User_Data => Plugin);
      
      Gtk_New(Spec.Config.Min_Class_Id, 5.0, 65.0, 1.0);
      Set_Value(Spec.Config.Min_Class_Id, Gdouble(Gen_Synth_Plugin_Record(Plugin.all).Min_Class_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame min class id  (has key type) : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Min_Class_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
            
      Plugin_Cb.Connect
        (Spec.config.Min_Class_Id, "value_changed", Plugin_Cb.To_Marshaller(Min_Class_Id_Synth_Callback'Access),
	 User_Data => Plugin);
      
      Gtk_New(Spec.Config.Max_Class_Id, 24.0, 49.0, 1.0);
      Set_Value(Spec.Config.Max_Class_Id, Gdouble(Gen_Synth_Plugin_Record(Plugin.all).Max_Class_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame max class id  (has key type) : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Max_Class_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
            
      Plugin_Cb.Connect
        (Spec.config.Max_Class_Id, "value_changed", Plugin_Cb.To_Marshaller(Max_Class_Id_Synth_Callback'Access),
	 User_Data => Plugin);
      
      
      Gtk_New(Spec.Config.Min_Value_Id, 25.0, 65.0, 1.0);
      Set_Value(Spec.Config.Min_Value_Id, Gdouble(Gen_Synth_Plugin_Record(Plugin.all).Min_Value_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame min Value id (has sens type)  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Min_Value_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
            
      Plugin_Cb.Connect
        (Spec.config.Min_Value_Id, "value_changed", Plugin_Cb.To_Marshaller(Min_Value_Id_Synth_Callback'Access),
	 User_Data => Plugin);
      
      Gtk_New(Spec.Config.Max_Value_Id, 25.0, 127.0, 1.0);
      Set_Value(Spec.Config.Max_Value_Id, Gdouble(Gen_Synth_Plugin_Record(Plugin.all).Max_Value_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame max Value id (has sens type)  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Max_Value_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
            
      Plugin_Cb.Connect
        (Spec.config.Max_Value_Id, "value_changed", Plugin_Cb.To_Marshaller(Max_Value_Id_Synth_Callback'Access),
	 User_Data => Plugin);
      
      Gtk_New(Spec.Config.Min_Data_Id, 2.0, 64.0, 1.0);
      Set_Value(Spec.Config.Min_Data_Id, Gdouble(Gen_Synth_Plugin_Record(Plugin.all).Min_Data_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame min Data id (has length type)  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Min_Data_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
            
      Plugin_Cb.Connect
        (Spec.config.Min_Data_Id, "value_changed", Plugin_Cb.To_Marshaller(Min_Data_Id_Synth_Callback'Access),
	 User_Data => Plugin);
      
      Gtk_New(Spec.Config.Max_Data_Id, 4.0, 127.0, 1.0);
      Set_Value(Spec.Config.Max_Data_Id, Gdouble(Gen_Synth_Plugin_Record(Plugin.all).Max_Data_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame max Data id (has length type)  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Max_Data_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
            
      Plugin_Cb.Connect
        (Spec.config.Max_Data_Id, "value_changed", Plugin_Cb.To_Marshaller(Max_Data_Id_Synth_Callback'Access),
	 User_Data => Plugin);
      
      Add (Spec.Specifications_Frame, Vbox);
      
      
      --Put_Line("Load seq 0.1.8.1");
      
   end Initialize;
   
   
   procedure Max_B_Inf_Drums_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Drums_Plugin_Record(Plugin.all).Max_B_Inf := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Max_B_Inf_Drums_Callback;
   
   procedure Max_B_Sup_Drums_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Drums_Plugin_Record(Plugin.all).Max_B_Sup := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Max_B_Sup_Drums_Callback;
   
   
   procedure Min_Class_Id_Drums_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Drums_Plugin_Record(Plugin.all).Min_Class_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Min_Class_Id_Drums_Callback;
   
   procedure Max_Class_Id_Drums_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Drums_Plugin_Record(Plugin.all).Max_Class_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Max_Class_Id_Drums_Callback;

   
   procedure Min_Value_Id_Drums_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Drums_Plugin_Record(Plugin.all).Min_Value_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Min_Value_Id_Drums_Callback;
   
   procedure Max_Value_Id_Drums_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Drums_Plugin_Record(Plugin.all).Max_Value_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Max_Value_Id_Drums_Callback;
   
   procedure Min_Data_Id_Drums_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Drums_Plugin_Record(Plugin.all).Min_Data_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Min_Data_Id_Drums_Callback;
   
   procedure Max_Data_Id_Drums_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Gen_Drums_Plugin_Record(Plugin.all).Max_Data_Id := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Max_Data_Id_Drums_Callback;

   
   procedure Initialize (Spec : in out Genetical_Drums_Specifications;
     			 Plugin : in Abstract_Plugin_access) is
      
      
      Vbox : Gtk_Vbox;
      Label : Gtk_Label;
      Hbox : Gtk_Hbox;
   begin                  
      
      
      Gtk_New(Spec.Specifications_Frame, "Genetical Drums : ");      
      
      Gtk_New_Vbox(Vbox, Homogeneous => False);
      
      Gtk_New(Spec.Config.Max_B_inf, 1.0, 1.0, 1.0);
      Set_Value(Spec.Config.Max_B_inf, Gdouble(Gen_Drums_Plugin_Record(Plugin.all).Max_B_Inf));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame b_inf (has constant 1  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Max_B_Inf, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
            
      Plugin_Cb.Connect
        (Spec.config.Max_B_Inf, "value_changed", Plugin_Cb.To_Marshaller(Max_B_inf_Drums_Callback'Access),
	 User_Data => Plugin);
      
      Gtk_New(Spec.Config.Max_B_Sup, 1.0, 4.0, 1.0);
      Set_Value(Spec.Config.Max_B_Sup, Gdouble(Gen_Drums_Plugin_Record(Plugin.all).Max_B_Sup));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame b_Sup (has max element)  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Max_B_Sup, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
            
      Plugin_Cb.Connect
        (Spec.config.Max_B_Sup, "value_changed", Plugin_Cb.To_Marshaller(Max_B_Sup_Drums_Callback'Access),
	 User_Data => Plugin);
      
      Gtk_New(Spec.Config.Min_Class_Id, 5.0, 24.0, 1.0);
      Set_Value(Spec.Config.Min_Class_Id, Gdouble(Gen_Drums_Plugin_Record(Plugin.all).Min_Class_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame min class id  (has key type) : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Min_Class_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
            
      Plugin_Cb.Connect
        (Spec.config.Min_Class_Id, "value_changed", Plugin_Cb.To_Marshaller(Min_Class_Id_Drums_Callback'Access),
	 User_Data => Plugin);
      
      Gtk_New(Spec.Config.Max_Class_Id, 25.0, 49.0, 1.0);
      Set_Value(Spec.Config.Max_Class_Id, Gdouble(Gen_Drums_Plugin_Record(Plugin.all).Max_Class_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame max class id  (has key type) : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Max_Class_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
            
      Plugin_Cb.Connect
        (Spec.config.Max_Class_Id, "value_changed", Plugin_Cb.To_Marshaller(Max_Class_Id_Drums_Callback'Access),
	 User_Data => Plugin);
      
      
      Gtk_New(Spec.Config.Min_Value_Id, 5.0, 25.0, 1.0);
      Set_Value(Spec.Config.Min_Value_Id, Gdouble(Gen_Drums_Plugin_Record(Plugin.all).Min_Value_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame min Value id (has sens type)  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Min_Value_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
            
      Plugin_Cb.Connect
        (Spec.config.Min_Value_Id, "value_changed", Plugin_Cb.To_Marshaller(Min_Value_Id_Drums_Callback'Access),
	 User_Data => Plugin);
      
      Gtk_New(Spec.Config.Max_Value_Id, 25.0, 127.0, 1.0);
      Set_Value(Spec.Config.Max_Value_Id, Gdouble(Gen_Drums_Plugin_Record(Plugin.all).Max_Value_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame max Value id (has sens type)  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Max_Value_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
            
      Plugin_Cb.Connect
        (Spec.config.Max_Value_Id, "value_changed", Plugin_Cb.To_Marshaller(Max_Value_Id_Drums_Callback'Access),
	 User_Data => Plugin);
      
      Gtk_New(Spec.Config.Min_Data_Id, 2.0, 24.0, 1.0);
      Set_Value(Spec.Config.Min_Data_Id, Gdouble(Gen_Drums_Plugin_Record(Plugin.all).Min_Data_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame min Data id (has length type)  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Min_Data_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
            
      Plugin_Cb.Connect
        (Spec.config.Min_Data_Id, "value_changed", Plugin_Cb.To_Marshaller(Min_Data_Id_Drums_Callback'Access),
	 User_Data => Plugin);
      
      Gtk_New(Spec.Config.Max_Data_Id, 28.0, 65.0, 1.0);
      Set_Value(Spec.Config.Max_Data_Id, Gdouble(Gen_Drums_Plugin_Record(Plugin.all).Max_Data_Id));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Frame max Data id (has length type)  : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Config.Max_Data_Id, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
            
      Plugin_Cb.Connect
        (Spec.config.Max_Data_Id, "value_changed", Plugin_Cb.To_Marshaller(Max_Data_Id_Drums_Callback'Access),
	 User_Data => Plugin);
      
      Add (Spec.Specifications_Frame, Vbox);
      --Put_Line("Load seq 0.1.8.1");
      
   end Initialize;
      
end Libsens.Gtk_Genetical;
