with Gtk.gentry;                        use Gtk.gEntry;
with Gtk.Spin_Button;                   use Gtk.Spin_Button;
with Gtk.Combo_Box_Text;                use Gtk.Combo_Box_Text;

with Libsens.Virtual;                   use Libsens.Virtual;
with Libsens.Virtual.Work_Class;        use Libsens.Virtual.Work_Class;

with Libsens.Gtk_Plugins_Specifications;use Libsens.Gtk_Plugins_Specifications;


package Libsens.Gtk_Neural is
   
   
   type Network_Record is tagged
      record
	 
	 Name              : Gtk_Entry;	 
	 Width             : Gtk_Spin_Button;	 
	 Sample_Max        : Gtk_Spin_Button;	 
	 Reuse             : Gtk_Combo_Box_Text;	 
	 Converged         : Gtk_Spin_Button;	 
         Max_Epoch         : Gtk_Spin_Button;	 
      end record;
   
   type Neural_Mono_Specifications is
     new Abstract_Plugin_Specifications(NN_Mono) with
      record	 
	 Network : Network_Record;
      end record;
   
   
   procedure Initialize (Spec : in out Neural_Mono_Specifications;
     			 Plugin : in Abstract_Plugin_Access);
   
   type Neural_Poly_Specifications is
     new Abstract_Plugin_Specifications(NN_Poly) with
      record	 
	 Network : Network_Record;
      end record;
   
   procedure Initialize (Spec : in out Neural_Poly_Specifications;
     			 Plugin : in Abstract_Plugin_Access);
   
   
   type Neural_Rythm_Specifications is
     new Abstract_Plugin_Specifications(NN_Rythm) with
      record	 
	 Network : Network_Record;
      end record;
   
   procedure Initialize (Spec : in out Neural_Rythm_Specifications;
     			 Plugin : in Abstract_Plugin_Access);
         
   
end Libsens.Gtk_Neural;
