
with Libsens.Gtk_Step_Sequencer;        use Libsens.Gtk_Step_Sequencer;
with Libsens.Gtk_Genetical;             use Libsens.Gtk_Genetical;
with Libsens.Gtk_Neural;                use Libsens.Gtk_Neural;
with Libsens.Gtk_Modulator;             use Libsens.Gtk_Modulator;
with Libsens.Gtk_Arpegiator;            use Libsens.Gtk_Arpegiator;
with Libsens.Gtk_Ctrl_Change;           use Libsens.Gtk_Ctrl_Change;
with Libsens.Gtk_Prgm_Change;           use Libsens.Gtk_Prgm_Change;
  
package body Libsens.Gtk_Plugins_Initialization is
   --------------------------------------------------------------------------------
   --                                                                            --
   --               Plugins Specifications initializations                       --
   --                                                                            --
   --------------------------------------------------------------------------------
   
   
   
   function Initialize (Class : Plugin_Enum;
   			Plugin : Abstract_Plugin_Access;
			Id : Plugin_num)
   		       return Plugin_Specifications_Access is  
      Spec : Plugin_Specifications_Access;
   begin
      case Class is
   	 when Null_Plugin =>
   	    null;	    
   	 when Step_Seq =>	    
   	    Spec := new Step_Seq_Specifications;
   	    Gtk_Step_Sequencer.Initialize(Step_Seq_Specifications(Spec.all), Plugin);
	 when Gen_Bass =>
	    Spec := new Genetical_Bass_Specifications;
   	    Gtk_Genetical.Initialize(Genetical_Bass_Specifications(Spec.all), Plugin);	    
	 when Gen_Synth =>
	    Spec := new Genetical_Synth_Specifications;
   	    Gtk_Genetical.Initialize(Genetical_Synth_Specifications(Spec.all), Plugin);
	 when Gen_Drums =>
	    Spec := new Genetical_Drums_Specifications;
   	    Gtk_Genetical.Initialize(Genetical_Drums_Specifications(Spec.all), Plugin);	    
	 when Nn_Mono =>
	    Spec := new Neural_Mono_Specifications;
   	    Gtk_Neural.Initialize(Neural_Mono_Specifications(Spec.all), Plugin);	    
	 when Nn_Poly =>
	    Spec := new Neural_Poly_Specifications;
   	    Gtk_Neural.Initialize(Neural_Poly_Specifications(Spec.all), Plugin);
	 when Nn_Rythm =>
	    Spec := new Neural_Rythm_Specifications;
   	    Gtk_Neural.Initialize(Neural_Rythm_Specifications(Spec.all), Plugin);	 	    
   	 when Arp_Seq =>	 
	    Spec := new Arpegiator_Specifications;
   	    Gtk_Arpegiator.Initialize(Arpegiator_Specifications(Spec.all), Plugin);
	 when NL_Mod =>
	    Spec := new Modulator_Specifications;
   	    Gtk_Modulator.Initialize(Modulator_Specifications(Spec.all), Plugin);
	 when CC_List =>
	    Spec := new Ctrl_Change_Specifications;
   	    Gtk_Ctrl_change.Initialize(Ctrl_Change_Specifications(Spec.all), Plugin);
	 when PC_List =>
	    Spec := new Prgm_Change_Specifications;
   	    Gtk_Prgm_change.Initialize(Prgm_Change_Specifications(Spec.all), Plugin);
      end case;
      
      return Spec;
   end Initialize;
   
   
end Libsens.Gtk_Plugins_Initialization;
