
with Glib;                              use Glib;
with Glib.Object;                       use Glib.Object;
with Glib.Values;                       use Glib.Values;
with Gtk.Handlers;                      use Gtk.Handlers;
pragma Elaborate_All (Gtk.Handlers);
with Gtk.Widget;                        use Gtk.Widget;
with Gtk.Enums;                         use Gtk.Enums;
with Gtk.Frame;                         use Gtk.Frame;

with Gtk.Tree_Model;                    use Gtk.Tree_Model;
with Gtk.Scrolled_Window;               use Gtk.Scrolled_Window;
with Gtk.Tree_View_Column;              use Gtk.Tree_View_Column;
with Gtk.Cell_Renderer_Text;            use Gtk.Cell_Renderer_Text;
with Gtk.Cell_Renderer_Toggle;          use Gtk.Cell_Renderer_Toggle;
with Gtk.Tree_Selection;                use Gtk.Tree_Selection;

with Libsens.Common;                    use Libsens.Common;
with Libsens.Virtual.Step_Sequencer;    use Libsens.Virtual.Step_Sequencer;


with Text_Io;                           use Text_Io;



package body Libsens.Gtk_Step_Sequencer is
   
   --------------------
   -- step sequencer --
   --------------------
   
   
   package Plugin_Object_CB is new Gtk.Handlers.User_Callback 
     (Gobject_Record,
      Abstract_Plugin_Access);   
   
   
   procedure Muted_Edited (Model  : access GObject_Record'Class;
			   Params : Glib.Values.GValues;
			   Plugin : Abstract_Plugin_Access) is
      
      
      
      
      
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Iter        : constant Gtk_Tree_Iter := Get_Iter_From_String (M, Path_String);
      
      Old_Value   : Boolean := False;
      
      Id : Natural := 0;
      
   begin
      Old_Value := Get_Boolean (M, Iter, Muttable_Column+1);
      
      Id := Integer'Value
	(
	 (Get_String (M, Get_Iter_From_String 
			(M, Get_String (Nth (Params, 1))), Text_Column)));
      
      Step_Seq_Plugin_Record(Plugin.all).Sequencer(Id).played := not Step_Seq_Plugin_Record(Plugin.all).Sequencer(Id).Played;      
      Set (M, Iter, Muttable_Column+1, not Old_Value);
   end Muted_Edited;
   
   procedure Loop_Edited (Model  : access GObject_Record'Class;
			  Params : Glib.Values.GValues;
			   Plugin : Abstract_Plugin_Access) is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Iter        : constant Gtk_Tree_Iter := Get_Iter_From_String (M, Path_String);
      
      Old_Value   : Boolean;
      
      Id : Natural := 0;
      
   begin
      Old_Value := Get_Boolean (M, Iter, Loop_Column-1);
      
      Id := Integer'Value
	(
	 (Get_String (M, Get_Iter_From_String 
			(M, Get_String (Nth (Params, 1))), Text_Column)));
      
      
      Step_Seq_Plugin_Record(Plugin.all).Sequencer(Id).In_Loop := not Step_Seq_Plugin_Record(Plugin.all).Sequencer(Id).In_Loop;
      Set (M, Iter, Loop_Column-1, not Old_Value);
   end Loop_Edited;
   

   
   procedure Key_Edited (Model  : access GObject_Record'Class;
			 Params : Glib.Values.GValues;
			 Plugin : Abstract_Plugin_Access) is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Text_Value  : constant Gvalue := Nth (Params, 2);
      Iter        : constant Gtk_Tree_Iter :=
	Get_Iter_From_String (M, Path_String);
      
      
      
      Id : Natural := 0;
      Value : Integer := 0;
   begin
      
      
      Id := Integer'Value
	(
	 (Get_String (M, Get_Iter_From_String 
			(M, Get_String (Nth (Params, 1))), Text_Column)));
      
      begin
	 Value := Integer'Value(Get_String(Text_Value));      
	 Step_Seq_Plugin_Record(Plugin.all).Sequencer(Id).Key := Key_Type(Value);
      
	 Set (M, Iter, Keys_Column, Integer'Image(Value));
      exception
	 when Constraint_Error =>
	    null;
      end;
      
   end Key_Edited;
   
   procedure Sens_Edited (Model  : access GObject_Record'Class;
			  Params : Glib.Values.GValues;
			  Plugin : Abstract_Plugin_Access)  is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Text_Value  : constant GValue := Nth (Params, 2);
      Iter        : constant Gtk_Tree_Iter :=
	Get_Iter_From_String (M, Path_String);
      
      
      
      Id : Natural := 0;
      Value : Integer := 0;
   begin
      
      Id := Integer'Value
	(
	 (Get_String (M, Get_Iter_From_String 
			(M, Get_String (Nth (Params, 1))), Text_Column)));
      begin
	 Value := Integer'Value(Get_String(Text_Value));
	 
	 Step_Seq_Plugin_Record(Plugin.all).Sequencer(Id).Sens := Sens_Type(Value);
	 
	 Set (M, Iter, Sens_Column, Integer'Image(Value));
      exception
	 when Constraint_Error =>
	    null;
      end;
      
   end Sens_Edited;
   
   procedure Length_Edited (Model  : access GObject_Record'Class;
			    Params : Glib.Values.GValues;
			    Plugin : Abstract_Plugin_Access)  is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Text_Value  : constant GValue := Nth (Params, 2);
      Iter        : constant Gtk_Tree_Iter :=
	Get_Iter_From_String (M, Path_String);
      
      
      
      Id : Natural := 0;
      Value : Integer := 0;
   begin
      
      Id := Integer'Value
	(
	 (Get_String (M, Get_Iter_From_String 
			(M, Get_String (Nth (Params, 1))), Text_Column)));
      begin
	 Value := Integer'Value(Get_String(Text_Value));
	 
	 Step_Seq_Plugin_Record(Plugin.all).Sequencer(Id).Length := Length_Type(Value);
	 
	 Set (M, Iter, Length_Column, Integer'Image(Value));
      exception
	 when Constraint_Error =>
	    null;
      end;
      
   end Length_Edited;
   
   procedure Bar_Edited (Model  : access GObject_Record'Class;
			 Params : Glib.Values.GValues;
			 Plugin : Abstract_Plugin_Access)  is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Text_Value  : constant GValue := Nth (Params, 2);
      Iter        : constant Gtk_Tree_Iter :=
	Get_Iter_From_String (M, Path_String);
      
      
      
      Id : Natural := 0;
      Value : Integer := 0;
   begin
      
      
      Id := Integer'Value
	(
	 (Get_String (M, Get_Iter_From_String 
			(M, Get_String (Nth (Params, 1))), Text_Column)));      
      begin
	 Value := Integer'Value(Get_String(Text_Value));
	 
	 Step_Seq_Plugin_Record(Plugin.all).Sequencer(Id).Bar := Value;
      
	 Set (M, Iter, Bar_Column, Integer'Image(Value));
      exception
	 when Constraint_Error =>
	    null;
      end;
      
   end Bar_Edited;
   
   procedure Number_Edited (Model  : access GObject_Record'Class;
			    Params : Glib.Values.GValues;
			 Plugin : Abstract_Plugin_Access)  is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Text_Value  : constant GValue := Nth (Params, 2);
      Iter        : constant Gtk_Tree_Iter :=
	Get_Iter_From_String (M, Path_String);
      
      
      
      Id : Natural := 0;
      Value : Integer := 0;
   begin
      
      Id := Integer'Value
	(
	 (Get_String (M, Get_Iter_From_String 
			(M, Get_String (Nth (Params, 1))), Text_Column)));      
      begin
	 Value := Integer'Value(Get_String(Text_Value));
	 
	 Step_Seq_Plugin_Record(Plugin.all).Sequencer(Id).Number := Value;
	 
	 Set (M, Iter, Number_Column-3, Integer'Image(Value));
      exception
	 when Constraint_Error =>
	    null;
      end;
      
   end Number_Edited;

   	    
         
   procedure Step_Edited (Model  : access GObject_Record'Class;
			  Params : Glib.Values.GValues;
			 Plugin : Abstract_Plugin_Access)  is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Text_Value  : constant GValue := Nth (Params, 2);
      Iter        : constant Gtk_Tree_Iter :=
	Get_Iter_From_String (M, Path_String);
      
      
      
      Id : Natural := 0;
      Value : Integer := 0;
   begin
      
      
      Id := Integer'Value
	(
	 (Get_String (M, Get_Iter_From_String 
			(M, Get_String (Nth (Params, 1))), Text_Column)));      
      begin
	 Value := Integer'Value(Get_String(Text_Value));
	 
	 Step_Seq_Plugin_Record(Plugin.all).Sequencer(Id).Step := Value;
	 
	 Set (M, Iter, Step_Column-3, Integer'Image(Value));
      exception
	 when Constraint_Error =>
	    null;
      end;
      
   end Step_Edited;
   
   procedure Note_Edited (Model  : access GObject_Record'Class;
			  Params : Glib.Values.GValues;
			 Plugin : Abstract_Plugin_Access)  is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Text_Value  : constant GValue := Nth (Params, 2);
      Iter        : constant Gtk_Tree_Iter :=
	Get_Iter_From_String (M, Path_String);
      
      
      
      Id : Natural := 0;
      
   begin
      
      
      Id := Integer'Value
	(
	 (Get_String (M, Get_Iter_From_String 
			(M, Get_String (Nth (Params, 1))), Text_Column)));      
      
      Free(Step_Seq_Plugin_Record(Plugin.all).Sequencer(Id).Note);
      Step_Seq_Plugin_Record(Plugin.all).Sequencer(Id).Note := new String ' (Get_String (Text_Value));
      
      Set_value (M, Iter, Type_Column+2, Text_value);
   end Note_Edited;
   
   procedure Octave_Edited (Model  : access GObject_Record'Class;
			    Params : Glib.Values.GValues;
			    Plugin : Abstract_Plugin_Access)  is
      M           : constant Gtk_Tree_Store := Gtk_Tree_Store (Model);
      Path_String : constant String := Get_String (Nth (Params, 1));
      Text_Value  : constant GValue := Nth (Params, 2);
      Iter        : constant Gtk_Tree_Iter :=
	Get_Iter_From_String (M, Path_String);
      
      
      
      Id : Natural := 0;
      Value : Octave_num := 0;
   begin
      Id := Integer'Value
	(
	 (Get_String (M, Get_Iter_From_String 
			(M, Get_String (Nth (Params, 1))), Text_Column)));
      begin
	 Value :=  Octave_num'Value(Get_String(Text_Value));
	 
	 Step_Seq_Plugin_Record(Plugin.all).Sequencer(Id).Octave := Value;
	 Set (M, Iter, Transpose_Column-1, Integer'Image(Integer(Value)));	 
      exception
	 when Constraint_Error =>
	    null;
      end;
      
	 
      end Octave_Edited;
   

   ------------------
   -- Add_Key_Line --
   ------------------
   function Add_Key_Line
     (Model     : access Gtk_Tree_Store_Record'Class;
      Id        : Integer;
      Keys      : Integer := 64;
      Sens      : Integer := 64;
      Length    : Integer := 8;
      Bar       : Integer := 1;
      Number    : Integer := 1;
      Step      : Integer := 1;
      Note      : String := "";
      Played    : Boolean := True;      
      Muttable  : Boolean := False;      
      Transpose : Integer := 0;
      In_Loop   : Boolean := False;
      Parent    : Gtk_Tree_Iter := Null_Iter) return Gtk_Tree_Iter
      is
     Iter : Gtk_Tree_Iter;
   begin
      --Put_Line("Add key 1.0");
      Append (Model, Iter, Parent);
      --Put_Line("Add key 1.1");
      Set (Model, Iter, Text_Column, Integer'Image(Id));
      
      Set (Model, Iter, Keys_Column, Integer'Image(Keys));
      
      Set (Model, Iter, Sens_Column, Integer'Image(Sens));

      Set (Model, Iter, Length_Column, Integer'Image(Length));                 
      
      Set (Model, Iter, Bar_Column, Integer'Image(Bar));
      
      Set (Model, Iter, Number_Column-3, Integer'Image(Number));
      
      Set (Model, Iter, Step_Column-3, Integer'Image(Step));
      
      Set (Model, Iter, Type_Column+2, Note);      

      Set (Model, Iter, Muttable_Column+1, Muttable);
      
      Set (Model, Iter, Transpose_Column-1, Integer'Image(Transpose));
      
      Set (Model, Iter, Loop_Column-1, In_Loop);
      
      Set (Model, Iter, Editable_Column+10, True);
      
      return Iter;
   end Add_Key_Line;
   
   
   
   procedure Bars_Max_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      Step_Seq_Plugin_Record(Plugin.all).Bars_Max := Integer(Gtk.Spin_Button.Get_Value(Gtk_Spin_Button(Widget)));
   exception
      when others =>
	 null;
   end Bars_Max_Callback;

   package Plugin_Cb is new Gtk.Handlers.User_Callback 
     (Gtk.Widget.Gtk_Widget_Record, 
      Abstract_Plugin_Access);
   
            
   procedure Initialize (Spec : in out Step_Seq_Specifications;
     			 Plugin : in Abstract_Plugin_access) is
      
      Scrolled   : Gtk_Scrolled_Window;            
      
      -- Comon Tree      
      Col      : Gtk_Tree_View_Column;
      Num      : Gint;
      Text_Render   : Gtk_Cell_Renderer_Text;
      Toggle_Render : Gtk_Cell_Renderer_Toggle;
      
      Parent, Iter  : Gtk_Tree_Iter;
      pragma Unreferenced (Num);
      pragma Warnings (Off, Iter);
      
      
      Vbox : Gtk_Vbox;
      
   begin
      
      Gtk_New (Spec.Sequencer_Model,
	       (Text_column         => GType_String,
		keys_Column         => GType_String,
                Sens_Column         => GType_String,
		Length_Column       => GType_String,   
		bar_Column          => GType_String,
		Number_Column-3     => GType_String,
		Step_Column-3       => GType_String,
		Type_Column+2       => GType_String,		
		Muttable_Column+1   => GType_Boolean,
		Transpose_Column-1  => GType_String,
		Loop_Column-1       => GType_Boolean,
		Editable_Column+10   => GType_Boolean)
	      );
      
      --Put_Line("Load seq 0.1");
      
      Gtk_New (Spec.Sequencer_Tree, Spec.Sequencer_Model);
      --Put_Line("Load seq 0.1.1");
      Set_Grid_Lines (Spec.Sequencer_Tree, Grid_Lines_Vertical);
      --Put_Line("Load seq 0.1.2");
      Set_Enable_Tree_Lines (Spec.Sequencer_Tree, True);
      --Put_Line("Load seq 0.1.3");
      Set_Rubber_Banding (Spec.Sequencer_Tree, True);
      --Put_Line("Load seq 0.1.4");
      Set_Mode (Get_Selection (Spec.Sequencer_Tree), Selection_Multiple);
      --Put_Line("Load seq 0.1.5");
      Gtk_New (Scrolled);
      --Put_Line("Load seq 0.1.6");
      Set_Policy (Scrolled, Policy_Always, Policy_Always);
      --Put_Line("Load seq 0.1.7");
      Add (Scrolled, Spec.Sequencer_Tree);            
      --Put_Line("Load seq 0.1.8");
      
      
      Gtk_New(Spec.Specifications_Frame, "Step sequencer : ");      
      --Put_Line("Load seq 0.1.8.1");
      Gtk_New(Spec.Bars_Max, 1.0, 65537.0, 1.0);
      if Plugin /= null then
	 Set_Value(Spec.Bars_Max, Gdouble(Step_Seq_Plugin_Record(Plugin.all).Bars_Max));
      end if;
      --Put_Line("Load seq 0.1.8.2");
      
      Plugin_Cb.Connect
        (Spec.Bars_Max, "value_changed", Plugin_Cb.To_Marshaller(Bars_Max_Callback'Access),
	 User_Data => Plugin);
      
      --Put_Line("Load seq 0.1.8.3");
      Gtk_New_Vbox(Vbox, Homogeneous => false);
      Gtk_New_Hbox(Spec.Hbox, Homogeneous => False);
      Gtk_New(Spec.Label, "Bars max : ");
      Pack_Start(Spec.Hbox, Spec.Label, False, False, 2);
      Pack_Start(Spec.Hbox, Spec.Bars_Max, False, False, 2);
      Pack_Start(Vbox, Spec.hbox, False, False, 2);
      Pack_End(Vbox, scrolled);
      Add (Spec.Specifications_Frame, Vbox);      
      --Put_Line("Load seq 0.2");
      
      Gtk_New (Text_Render);
      Gtk_New (Col);
      Num := Append_Column (Spec.Sequencer_Tree, Col);      
      Set_Sort_Column_Id (Col, Keys_Column);
      Set_Title (Col, "Id");
      Pack_Start (Col, Text_Render, True);
      Set_Sizing (Col, Tree_View_Column_Autosize);
      Add_Attribute (Col, Text_Render, "text", Text_Column);      
      --Put_Line("Load seq 0.3");
      
      Gtk_New (Text_Render);
      Gtk_New (Col);
      Num := Append_Column (Spec.Sequencer_Tree, Col);
      Set_Sort_Column_Id (Col, Keys_Column);
      Set_Title (Col, "Key");
      Pack_Start (Col, Text_Render, True);
      Set_Sizing (Col, Tree_View_Column_Autosize);
      Add_Attribute (Col, Text_Render, "text", Keys_Column);          
      Add_Attribute (Col, Text_Render, "editable", Editable_Column+10);
      Plugin_Object_CB.Object_Connect
        (Text_Render, "edited", Key_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      --Put_Line("Load seq 0.4");
      
      Gtk_New (Text_Render);
      Gtk_New (Col);
      Num := Append_Column (Spec.Sequencer_Tree, Col);      
      Set_Title (Col, "Sens");
      Pack_Start (Col, Text_Render, True);
      Set_Sizing (Col, Tree_View_Column_Autosize);
      Add_Attribute (Col, Text_Render, "text", Sens_Column);
      Add_Attribute (Col, Text_Render, "editable", Editable_Column+10);
      Plugin_Object_CB.Object_Connect
        (Text_Render, "edited", Sens_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      --Put_Line("Load seq 0.5");
      
      Gtk_New (Text_Render);
      Gtk_New (Col);
      Num := Append_Column (Spec.Sequencer_Tree, Col);      
      Set_Title (Col, "Length");
      Pack_Start (Col, Text_Render, True);
      Set_Sizing (Col, Tree_View_Column_Autosize);
      Add_Attribute (Col, Text_Render, "text", Length_Column);
      Add_Attribute (Col, Text_Render, "editable", Editable_Column+10);
      Plugin_Object_CB.Object_Connect
        (Text_Render, "edited", Length_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      
      
      --Put_Line("Load seq 0.6");
      Gtk_New (Text_Render);
      Gtk_New (Col);
      Set_Sort_Column_Id (Col, -1);  --  unsortable
      Num := Append_Column (Spec.Sequencer_Tree, Col);
      Set_Title (Col, "Bar");
      Pack_Start (Col, Text_Render, False);
      Add_Attribute (Col, Text_Render, "text", Bar_Column);      
      Add_Attribute (Col, Text_Render, "editable", Editable_Column+10);
      Plugin_Object_CB.Object_Connect
        (Text_Render, "edited", Bar_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      
      --Put_Line("Load seq 0.7");
      
      Gtk_New (Text_Render);
      Gtk_New (Col);
      Set_Sort_Column_Id (Col, -1);  --  unsortable
      Num := Append_Column (Spec.Sequencer_Tree, Col);
      Set_Title (Col, "Number");
      Pack_Start (Col, Text_Render, False);
      Add_Attribute (Col, Text_Render, "text", Number_Column-3);
      Add_Attribute (Col, Text_Render, "editable", Editable_Column+10);
      Plugin_Object_CB.Object_Connect
        (Text_Render, "edited", Number_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      
      --Put_Line("Load seq 0.8");
      
      Gtk_New (Text_Render);
      --Put_Line("Load seq 0.8.1");
      Gtk_New (Col);
      --Put_Line("Load seq 0.8.2");
      Set_Sort_Column_Id (Col, -1);  --  unsortable
      --Put_Line("Load seq 0.8.3");
      Num := Append_Column (Spec.Sequencer_Tree, Col);
      --Put_Line("Load seq 0.8.4");
      Set_Title (Col, "Step");
      Pack_Start (Col, Text_Render, False);
      --Put_Line("Load seq 0.8.5");
      Add_Attribute (Col, Text_Render, "text", Step_Column-3);
      --Put_Line("Load seq 0.8.6");
      Add_Attribute (Col, Text_Render, "editable", Editable_Column+10);
      --Put_Line("Load seq 0.8.7");
      Plugin_Object_CB.Object_Connect
        (Text_Render, "edited", Step_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      
      --Put_Line("Load seq 0.9");
      Gtk_New (Text_Render);
      Gtk_New (Col);
      Set_Sort_Column_Id (Col, -1);  --  unsortable
      Num := Append_Column (Spec.Sequencer_Tree, Col);
      Set_Title (Col, "Note");
      Pack_Start (Col, Text_Render, False);
      Add_Attribute (Col, Text_Render, "text", Type_Column+2);
      Add_Attribute (Col, Text_Render, "editable", Editable_Column+10);
      Plugin_Object_CB.Object_Connect
        (Text_Render, "edited", Note_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      --Put_Line("Load seq 0.10");
      
      Gtk_New (Toggle_Render);
      Gtk_New (Col);
      Set_Sort_Column_Id (Col, -1);  --  unsortable
      Num := Append_Column (Spec.Sequencer_Tree, Col);
      Set_Title (Col, "Mute");
      Pack_Start (Col, Toggle_Render, False);      
      Add_Attribute (Col, Toggle_Render, "active", Muttable_Column+1);      
      Plugin_Object_CB.Object_Connect
        (Toggle_Render, "toggled", Muted_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      
      --Put_Line("Load seq 0.11");
      
      Gtk_New (Toggle_Render);
      Gtk_New (Col);
      Set_Sort_Column_Id (Col, -1);  --  unsortable
      Num := Append_Column (Spec.Sequencer_Tree, Col);
      Set_Title (Col, "In loop");
      Pack_Start (Col, Toggle_Render, False);      
      Add_Attribute (Col, Toggle_Render, "active", Loop_Column-1);      
      Plugin_Object_CB.Object_Connect
        (Toggle_Render, "toggled", loop_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);
      --Put_Line("Load seq 0.12");
      
      Gtk_New (Text_Render);
      Gtk_New (Col);
      Set_Sort_Column_Id (Col, -1);  --  unsortable
      Num := Append_Column (Spec.Sequencer_Tree, Col);
      Set_Title (Col, "Oct");
      Pack_Start (Col, Text_Render, False);      
      Add_Attribute (Col, Text_Render, "text", Transpose_Column-1);
      Add_Attribute (Col, Text_Render, "editable", Editable_Column+10);
      Plugin_Object_CB.Object_Connect
        (Text_Render, "edited", Octave_Edited'Access,
	 Slot_Object => Spec.Sequencer_Model,
	 User_Data => Plugin);

      --Put_Line("Load seq 0.13");
      Parent := Null_Iter;
      --Put_Line("Load seq 0.14");
      for Count in Step_Seq_Plugin_Record(Plugin.all).Sequencer'range loop	 
	 declare
	    Voice : constant Voice_Type := Step_Seq_Plugin_Record(Plugin.all).Sequencer(Count);
	 begin
	    
	    --Put_Line("Load seq 0.15");
	    
	    Iter := Add_Key_Line
	      (Spec.Sequencer_Model, 
	       Id => count,
	       Keys => Integer(Voice.Key),
	       Sens => Integer(Voice.Sens),
	       Length => Integer(Voice.Length),
	       Bar => Integer(Voice.Bar),
	       Number => Integer(Voice.Number),
	       Step => Integer(Voice.Step), 
	       Note => Voice.Note.all,
	       Played => Voice.Played,
	       Muttable => not Voice.played,	      
	       Transpose => Integer(Voice.Octave),
	       In_Loop => Voice.In_Loop,
	       Parent => Parent);

	    
	    --Put_Line("Load seq 0.16");
	 end;
      end loop;            
      -- End Sequencer View
      --Put_Line("Load seq 1.0");

      
      
   end Initialize;
   
   
   --  procedure Load_specifications (Page : in out Plugin_Page_Type;
   --  				  Plugin : in Abstract_Plugin_Access;
   --  				  Id : in Plugin_Num) is
   --     --  Scrolled   : Gtk_Scrolled_Window;            
      
   --     --  -- Comon Tree      
   --     --  Col      : Gtk_Tree_View_Column;
   --     --  Num      : Gint;
   --     --  Text_Render   : Gtk_Cell_Renderer_Text;
   --     --  Toggle_Render : Gtk_Cell_Renderer_Toggle;
      
   --     --  Parent, Iter  : Gtk_Tree_Iter;
   --     --  pragma Unreferenced (Num);
   --     --  pragma Warnings (Off, Iter);
      
      
   --     --  Vbox : Gtk_Vbox;
      
   --  begin
   --     Page.Plugin_Spec := Initialize(Plugin.Class, Plugin, Id);--New Step_Seq_Specifications;
   --  end Load_Specifications;
   
end Libsens.Gtk_Step_Sequencer;
