
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--                                                                                                                                                                         --
--                                                                      ---------------------------                                                                        --
--                                                                      --       El-Sofware      --                                                                        --
--                                                                      ---------------------------                                                                        --
--                                                                                                                                                                         --
--                                                                                present                                                                                  --
--                                                                                                                                                                         --
--                                                                            ---------------                                                                              --
--                                                                            --  MidiSurf --                                                                              --
--                                                                            ---------------                                                                              --
--                                                                                                                                                                         --
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--                                                                                                                                                                         --
-- Auteur      : Manuel De Girardi                                                                                                                                         --
-- Date        : 25/11/2010                                                                                                                                                --
-- Description : Surface de contrôle pour instrument MIDI                                                                                                                  --
--                                                                                                                                                                         --
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------


with Gtk.Frame;                         use Gtk.Frame;
with Gtk.Label;                         use Gtk.Label;
with Gtk.Box;                           use Gtk.Box;
with Gtk.Spin_Button;                   use Gtk.Spin_Button;
with Gtk.Check_Button;                  use Gtk.Check_Button;
with Gtk.GEntry;                        use Gtk.GEntry;
with Gtk.Button;                        use Gtk.Button;
with Gtk.File_Selection;                use Gtk.File_Selection;


with Libsens.Output_Drivers;                 use Libsens.Output_Drivers;
with Libsens.Midi_Types;                     use Libsens.Midi_Types;

with Calendar;                          use Calendar;

with Ada.Finalization;

package Libsens.Intelligences is


   type T_Intelligence;
   
   task type T_Intelligence_Driver(Intelligence : access T_Intelligence) is
      entry Start
        (Top : in Time;
         Bpm : in T_Bpm;
         Channel : in T_Channel;
         Chord : in T_Chord);
      entry Stop;
      entry Halt;
      entry reset;
      entry Set_Last_Step
        (Last : in Positive);
      entry Set_Transpose(Transpose : in Integer);
   end T_Intelligence_Driver;


   type T_Note is new Ada.Finalization.Limited_Controlled with private;
   
   type Note_Access is access all T_Note;

   type T_Note_Table is array (Positive range <>) of Note_Access;
   
   type T_Step is new Ada.Finalization.Limited_Controlled with private;
   type Step_Access is access all T_Step;

   type T_Step_Table is array (Positive range <>) of Step_access;


   type T_Intelligence is
      record
         Main_Frame            : Gtk_Frame;
	 --
         Main_Vbox             : Gtk_Vbox;
         Main_Hbox             : Gtk_Hbox;
         Parameters            : Gtk_Vbox;
         Key_Label             : Gtk_Label;
         Sens_Label            : Gtk_Label;
         Label_Vbox            : Gtk_Vbox;
         --
	 --
         Chord_Hbox            : Gtk_Hbox;

         Last_Label            : Gtk_Label;
         --
         Last_Spin_Button      : Gtk_Spin_Button;
         Transpose_Label       : Gtk_Label;
         --
         Transpose_Spin_Button : Gtk_Spin_Button;

         Network_Parameters    : Gtk_Vbox;
         Filename_Label        : Gtk_Label;
         Filename_Gentry       : Gtk_Gentry;
         File_Selection_button : Gtk_Button;
         File_Selection        : Gtk_File_Selection;
	 --
         Step_Table            : T_Step_Table(1..32);
         Stepseq_Hbox          : Gtk_Hbox;
         Step_Parameters       : Gtk_Vbox;
      end record;

   type Intelligence_Access is access all T_Intelligence;

   procedure Initialize
     (Intelligence : in out Intelligence_Access;
      Driver       : in Output_Driver_Access);


private
   type T_Note is new Ada.Finalization.Limited_Controlled with
      record
         Note_Vbox          : Gtk_Vbox;
         Set_Check_button   : Gtk_Check_Button;
         Key_Spin_Button    : Gtk_Spin_Button;
         Sens_Spin_button   : Gtk_Spin_Button;
	 Length_Spin_button : Gtk_Spin_Button;
      end record;

   procedure Initialize
     (Note : in out Note_Access);


   type T_Step is new Ada.Finalization.Limited_Controlled with
      record
         Step_Vbox        : Gtk_Vbox;
         Step_Label       : Gtk_Label;         
         Set_Check_button : Gtk_Check_Button;
      end record;

   procedure Initialize
     (Step : in out Step_Access;
     Label : in string);



end Libsens.Intelligences;
