with System;

with Libsens.MIDI.Portmidi;             use Libsens.MIDI.Portmidi;

with Interfaces.C;
use Interfaces;

package Libsens.MIDI.Devices is   
   
   pragma Elaborate_Body(Libsens.MIDI.Devices);
   
   type Mode_Type is (MIDI_In, MIDI_Out);
   -- Le mode de dentrée/sortie
   
   type Device_Type is
      record
         Initialized    : Boolean := False;
         Mode           : Mode_Type;
         Id             : Integer := -1;
         Addr           : access System.Address;
         The_Deviceinfo : access Portmidi.DeviceInfo;
      end record;   
   -- Le type Device_type.   

   
   type Device_Access is access Device_Type;
      
   procedure Initialize (Device : in out Device_Type; Mode : in Mode_Type);
   -- Initialise un périphérique MIDI
   
   function  Initialized(Device : in     Device_Type) return Boolean;
   -- Renvoie vrai si le périphérique est initialisé.   
   
   procedure Open       (Device : in out Device_Type);
   -- Ouvre un périphérique selon le mode d'entrée sortie du périphérique.
   
   procedure Write      (Device : in     Device_Type; Message : in C.Long);
   -- Ecrit un message court à detisnation du périphérique de sortie.
   
   procedure Read       (Device : in     Device_Type; Message : out C.Long);
   -- Lit un message en provenance du périphérique d'entrée.
   
   procedure Close      (Device : in out Device_Type);
   -- Ferme un périphérique.
   
   function Name(Device : in Device_Type) return String;
   -- Renvoie le nom du périphérique.
   
   Not_Initialized : exception;
   -- Sera levée si l'on tente d'ouvrir un périphérique non initilaisé.
   
   Mode_Error      : exception;
   -- Sera levée si l'on tente d'écrire sur un périphérique d'entrée ou
   -- si l'on tente de lire sur un périphérique de sortie.               
end Libsens.MIDI.Devices;
