
with Libsens.MIDI.Messages;             use Libsens.MIDI.Messages;
with Interfaces.C;                      use Interfaces.C;
package body Libsens.Monophonic_Generator is
      
      
      
      
      procedure Initialize (Reuse : in Boolean; Converged : in Float; Max_Epochs : in Positive) is
      begin
	 Rand_Init(Samples);
	 Train(filename,
	       Samples,
	       Reuse,
	       Real(Converged),
	       Max_Epochs);
      end Initialize;
      
      function Respond(Problem  : in Node_Set) return Node_Set is
	 Response : Node_Set(1..width) := (others => 0.0);
      begin
	 Response := Respond(Filename, Problem);
	 for I in Response'Range loop
	    if Response(I) > 0.5 then
	       Response(I) := 1.0;
	    else
	       Response(I) := 0.0;
	    end if;
	 end loop;
	 return Response;
      end Respond;
      
      
      package body Neural2chord is
      
      function To_Value(Set : in Node_Set) return Value_Type is
	 Value : Value_Type := 0;
      begin
	 for I in reverse 0..6 loop	    
	    if Set(I+1) = 1.0 then
	       Value := Value+2**I;
	    end if;
	 end loop;
	 return Value;
      end To_Value;
      
      
      function To_Note(From : Node_Set) return Note_Type is
	 
	 Note : Note_Type;
	 Note_Set : Node_Set(1..7);
      begin
	 Note_Set := From(1..7);
	 Note.Key := Key_Type(To_Value(Note_Set));
	 Note_Set := From(8..14);
	 Note.Sens := Sens_Type(To_Value(Note_Set));
	 Note_Set := From(15..21);
	 Note.Length := Length_Type(To_Value(Note_Set));
	 return Note;
      end To_Note;
      
      
      
      function To_Chord(From : in Node_Set) return Notes_Set_Access is
	 Notes_Set : Notes_Set_Access := new Notes_Set_Type(1..From'Length/21);
      begin	 
	 for Note_Id in Notes_Set'Range loop
	    
	    begin
	       declare
		  Note_Set : Node_Set(1..21) := From((Note_Id-1)*21+1..(Note_Id*21));
	       begin
		  
		  Notes_Set(Note_Id) := To_Note(Note_Set);
		  
	       end;
	       
	    exception
	       when others => null;
	    end;
	 end loop;
	 return Notes_Set;
      end To_Chord;
   end Neural2chord;

      
end Libsens.Monophonic_Generator;
