with libsens.Neural_Network;

with PragmARC.REM_NN_Wrapper;
use PragmARC.REM_NN_Wrapper;

with Ada.Numerics.Float_Random;
use Ada.Numerics.Float_Random;


generic
   
   Network_Size : Positive;
   
   Hidden_Num   : Natural;
   
   Samples_Max  : Positive;
package Libsens.Neural_Generator is
   

   
   package Network is new Libsens.Neural_Network(Network_Size, Hidden_num);   
   use Network;
   
   
   subtype Register_Type is Node_Set(1..Network_Size);
   Float_Gen : Generator;
   
   
   procedure Rand_Init(Samples : in out Samples_Type);
   function Problem_Rand return Node_Set;                  
   
   
end Libsens.Neural_Generator;
