
with Libsens.Common;                    use Libsens.Common;
with Libsens.Virtual;                   use Libsens.Virtual;
with Libsens.Virtual.Work_Class;        use Libsens.Virtual.Work_Class;
with Libsens.Processing.Plugins;        use Libsens.Processing.Plugins;

with Ada.Calendar;                      use Ada.Calendar;
package Libsens.Processing.Neural_Arpegiator is
   
   type Neural_Arpegiator_Processing(Plugin : Abstract_Plugin_Access);
   
   task type Neural_Arpegiator_Process (Neural_Arpegiator : access Neural_Arpegiator_Processing) is
      entry Initialize(Options : in Work_Options_Access);
      entry Start(Start_time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type);
      entry Stop;
      entry Halt;      
   end Neural_Arpegiator_Process;
   
   type Neural_Arpegiator_Processing(Plugin : Abstract_Plugin_Access) is new Plugin_Processing(Arp_Seq) with
      record
	 Process : Neural_Arpegiator_Process(Neural_Arpegiator_Processing'Access);
      end record;
   
   
   procedure Initialize(Plugin_Process : in Neural_Arpegiator_Processing; Options : in Work_Options_Access);     
   procedure Start(Plugin_Process : in Neural_Arpegiator_Processing;Start_Time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type);
   procedure Stop(Plugin_Process : in Neural_Arpegiator_Processing);
   procedure Halt(Plugin_Process : in Neural_Arpegiator_Processing);
end Libsens.Processing.Neural_Arpegiator;
