
with Libsens.Common;                    use Libsens.Common;
with Libsens.Virtual;                   use Libsens.Virtual;
with Libsens.Virtual.Work_Class;        use Libsens.Virtual.Work_Class;
with Libsens.Processing.Plugins;        use Libsens.Processing.Plugins;

with Ada.Calendar;                      use Ada.Calendar;
package Libsens.Processing.Neural_Modulator is
   
   type Neural_Modulator_Processing(Plugin : Abstract_Plugin_Access);
   
   task type Neural_Modulator_Process (Neural_Modulator : access Neural_Modulator_Processing) is
      entry Initialize(Options : in Work_Options_Access);
      entry Start(Start_time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type);
      entry Stop;
      entry Halt;
   end Neural_Modulator_Process;
   
   type Neural_Modulator_Processing(Plugin : Abstract_Plugin_Access) is new Plugin_Processing(Nl_mod) with
      record
	 Process : Neural_Modulator_Process(Neural_Modulator_Processing'Access);
      end record;
   
   
   procedure Initialize(Plugin_Process : in Neural_Modulator_Processing; Options : in Work_Options_Access);
   
   procedure Start(Plugin_Process : in Neural_Modulator_Processing;Start_Time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type);
   procedure Stop(Plugin_Process : in Neural_Modulator_Processing);
   procedure Halt(Plugin_Process : in Neural_Modulator_Processing);
end Libsens.Processing.Neural_Modulator;
