
with Libsens.Common;                    use Libsens.Common;
with Libsens.Virtual;                   use Libsens.Virtual;
with Libsens.Virtual.Work_Class;        use Libsens.Virtual.Work_Class;
with Libsens.Processing.Plugins;        use Libsens.Processing.Plugins;

with Ada.Calendar;                      use Ada.Calendar;
package Libsens.Processing.Prgm_Change is
   
   type Prgm_Change_Processing(Plugin : Abstract_Plugin_Access);
   
   task type Prgm_Change_Process (Prgm_Change : access Prgm_Change_Processing) is
      entry Initialize(Options : in Work_Options_Access);
      entry Start(Start_time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type);
      entry Stop;
      entry Halt;
   end Prgm_Change_Process;
   
   type Prgm_Change_Processing(Plugin : Abstract_Plugin_Access) is new Plugin_Processing(Pc_List) with
      record
	 Process : Prgm_Change_Process(Prgm_Change_Processing'Access);
      end record;
   
   
   procedure Initialize(Plugin_Process : in Prgm_Change_Processing; Options : in Work_Options_Access);
   
   procedure Start(Plugin_Process : in Prgm_Change_Processing;Start_Time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type);
   procedure Stop(Plugin_Process : in Prgm_Change_Processing);
   procedure Halt(Plugin_Process : in Prgm_Change_Processing);
end Libsens.Processing.Prgm_Change;
