with Libsens.MIDI.Messages;             use LibSens.Midi.Messages;
with Libsens.MIDI.Portmidi;             use Libsens.MIDI.Portmidi;
with Libsens.MIDI.Drivers;              use Libsens.MIDI.Drivers;

with Libsens.Virtual.Step_Sequencer;    use Libsens.Virtual.Step_Sequencer;

with Libsens.Processing.Common;         use Libsens.Processing.Common;

with Ada.Calendar.Formatting;

with Text_Io;                           use Text_Io;

with Interfaces.C;                      use Interfaces.C;

package body Libsens.Processing.Step_Sequencer is
   
   procedure Initialize(Plugin_Process : in Step_Sequencer_Processing;Options : in Work_Options_Access) is
   begin
      Plugin_Process.Process.Initialize(Options);
   end Initialize;   
   
   
   procedure Start(Plugin_Process : in Step_Sequencer_Processing;Start_Time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type) is
   begin
      Plugin_Process.Process.Start(Start_Time, Tempo, Signature);
   end Start;
   
   procedure Stop(Plugin_Process : in Step_Sequencer_Processing) is
   begin
      Plugin_Process.Process.Stop;
   end Stop;
   
   procedure Halt(Plugin_Process : in Step_Sequencer_Processing) is
   begin
      Plugin_Process.Process.Halt;
   end Halt;
   
   
   task body Step_Sequencer_Process is      
      
      
      Start_Time  : Time := Clock;
      Quantum     : Duration := 0.0;
      
      Tempo : Tempo_Type := 120.0;	 
      Date      : Time := Clock;
      
      End_Of_Task : Boolean := False;
      Bar_Beat : Bar_Beat_Type;
      Signature : Time_Signature_Type := (4, 4);
      
      Current_Form : Form_Index_Type := 1;
      Current_Break    : Break_Type := Down_Break;
      Prev_Break       : Break_Type := Null_Break;	 
      Next_Break       : Break_Type := Down_Break;
      

      
      
      Options : access Work_Options_Record;
      
      Bars_Max : Positive := 1;
      
   begin
      while not End_Of_Task loop
	 loop
	    select
	       accept Initialize(Options : in Work_Options_Access) do
		  Put_Line("Plugin id : " &
			     Plugin_Num'Image(Step_Sequencer.Plugin.Id) &
			     " ready for process " &
			     Plugin_Enum'Image(Step_Sequencer.Plugin.Class));
		  Step_Sequencer_Process.Options := Options;
	       end Initialize;
	    or
	       
	       accept Start(Start_Time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type) do
		  Quantum :=  Duration(60000.0/Float(Tempo))/Signature.Unit/1000.0;
		  Step_Sequencer_Process.Tempo := Tempo;
		  Step_Sequencer_Process.Signature := Signature;
		  
		  Bar_Beat := (1, 1, 1);
		  Step_Sequencer_Process.Start_Time := Start_Time;
		  Bars_Max := Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).Bars_Max;		  
	       end Start;
	       exit;
	    or
	       accept  Stop;
	    or
	       accept Halt;
	       End_Of_Task := True;
	       exit;
	    end select;
	 end loop;
	 --Put_Line("step_seq started ::= MIMI 0.1.0");
	 while not End_Of_Task loop
	    select
	       accept Initialize(Options : in Work_Options_Access);
	    or
	       accept Start(Start_Time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type) do
		  Quantum :=  Duration(60000.0/Float(Tempo))/Signature.Unit/1000.0;
		  Step_Sequencer_Process.Tempo := Tempo;
		  Step_Sequencer_Process.Signature := Signature;		  
		  
		  Bars_Max := Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).Bars_Max;
	       end Start;
	    or
	       accept  Stop;
	       exit;
	    or
	       accept Halt;
	       End_Of_Task := True;
	       exit;
	    or
	       delay until Start_Time;
	       --Put_Line("step_seq started ::= MIMI 0.1.1");
	       --if current_form = Step_Sequencer.plugin.played_form then
		--  if Step_Sequencer.Plugin.Algo = Null_Algo then
	       if (not Step_Sequencer.plugin.mutted) 
		       and is_formed(Options.true_table,			       
				     Step_Sequencer.Plugin.Cat_id, 
				     Options.Prev_Break, 
				     Options.Next_Break) then
			--Put_Line("step_seq started ::= MIMI 0.1.2");
		  for voice_id in Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).sequencer'Range loop
		     
		     
		     if bar_beat.bar = Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).Sequencer(voice_id).bar then
			
			if (Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).Sequencer(voice_id).number = bar_beat.time_number) and
			  (Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).Sequencer(voice_id).step = bar_beat.time_unit) then
			   
			   
			   
			   if Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).sequencer(voice_id).played then
			      
			      --Put_Line("tutu 1.3");
			      declare
				 
				 date : time := start_time;
				 
				 Message_Note_On  : long := to_long(note_on(Channel_Type(Step_Sequencer.plugin.Ch_Id-1), 
										      long(Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).sequencer(voice_id).key),
										      long(Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).sequencer(voice_id).sens)));
				 
				 
				 
				 Message_Note_Off : long := to_long(note_off(Channel_Type(Step_Sequencer.plugin.Ch_Id-1), 
										       long(Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).sequencer(voice_id).key)));
				 
				 length   : duration := (quantum) * natural((Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).sequencer(voice_id).length));
			      begin
				 --Put_Line("tutu 1.4");
				 if Step_Sequencer.plugin.printed then
				    --Put_Line("tutu 1.4.1");
				    declare				       
				       printed_message : constant printed_message_access := new printed_message_type '
					 (source => new string ' (Positive'image(Positive(Step_Sequencer.plugin.id))),
					  destination => new string ' (Positive'Image(Positive(Step_Sequencer.plugin.device_id))),
					  data_type => new string ' (control_type'image(control_of(Message_Note_On))),
					  channel => new string ' (channel_type'image(channel_of(Message_Note_On))),
					  data1 => new string ' (interfaces.c.long'image(data1(Message_Note_On))),
					  data2 => new string ' (interfaces.c.long'image(data2(Message_Note_On))),
					  hour => new string ' (formatting.image(date, true)),
					  hexa_sum => new string ' (hex_image(Message_Note_On)),
					  long_sum => new string ' (long'image(Message_Note_On)));
				    begin
				       --Put_Line("tutu 1.4.1.0");
				       --print(printed_message.all);
				       
				       Step_Sequencer.box.receive(printed_message);
				       --Put_Line("messages sended to message box");
				       
				    end;
				    --Put_Line("tutu 1.4.2");
				    declare				       
				       printed_message : constant printed_message_access := new printed_message_type '
					 (source => new string ' (Positive'image(Positive(Step_Sequencer.plugin.id))),
					  destination => new string ' (Positive'Image(Positive(Step_Sequencer.plugin.Device_Id))),
					  data_type => new string ' (control_type'image(control_of(Message_Note_Off))),
					  channel => new string ' (channel_type'image(channel_of(Message_Note_Off))),
					  data1 => new string ' (interfaces.c.long'image(data1(Message_Note_Off))),
					  data2 => new string ' (interfaces.c.long'image(data2(Message_Note_Off))),
					  hour => new string ' (formatting.image(date+length, true)),
					  hexa_sum => new string ' (hex_image(Message_Note_Off)),
					  long_sum => new string ' (long'image(Message_Note_Off)));
				    begin
				       
				       --print(printed_message.all);
				       
				       Step_Sequencer.box.receive(printed_message);
				       --Put_Line("messages sended to message box");
				       
				    end;
				    --Put_Line("tutu 1.4.3");
				 end if;
				 --Put_Line("tutu 1.5");
				 
				 Step_Sequencer.Event_Process.Receive(Step_Sequencer.plugin.Device_Id, date, Message_Note_On, 0.0, tempo);
				 --Put_Line("tutu 1.6");
				 Step_Sequencer.Event_Process.Receive(Step_Sequencer.plugin.Device_Id, Date, Message_Note_Off, length, tempo);
				 --Put_Line("tutu 1.7");
			      end;
			   end if;
			   
			end if; 
			
		     elsif Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).sequencer(voice_id).in_loop and then
		       (((bar_beat.bar-1) mod bars_max)+1 = Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).sequencer(voice_id).bar) then
			
			
			if (Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).sequencer(voice_id).number = bar_beat.time_number) and
			  (Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).sequencer(voice_id).step = bar_beat.time_unit) then
			   
			   
			   if Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).sequencer(voice_id).played then
			      
			      
			      --Put_Line("tatata 1.3");
			      declare
				 
				 date : time := start_time;
				 
				 Message_Note_On  : long := to_long(note_on(Channel_Type(Step_Sequencer.plugin.Ch_Id-1), 
										      long(Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).sequencer(voice_id).key),
										      long(Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).sequencer(voice_id).sens)));
				 
				 
				 
				 Message_Note_Off : long := to_long(note_off(Channel_Type(Step_Sequencer.plugin.Ch_Id-1), 
										       long(Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).sequencer(voice_id).key)));
				 
				 length   : duration := (quantum) * natural((Step_Seq_Plugin_Record(Step_Sequencer.Plugin.all).sequencer(voice_id).length));
			      begin
				 --Put_Line("tatata 1.4");
				 if Step_Sequencer.plugin.printed then
				    --Put_Line("tatata 1.4.1");
				    declare				       
				       printed_message : constant printed_message_access := new printed_message_type '
					 (source => new string ' (Positive'image(Positive(Step_Sequencer.plugin.id))),
					  destination => new string ' (Positive'Image(Positive(Step_Sequencer.plugin.device_id))),
					  data_type => new string ' (control_type'image(control_of(Message_Note_On))),
					  channel => new string ' (channel_type'image(channel_of(Message_Note_On))),
					  data1 => new string ' (interfaces.c.long'image(data1(Message_Note_On))),
					  data2 => new string ' (interfaces.c.long'image(data2(Message_Note_On))),
					  hour => new string ' (formatting.image(date, true)),
					  hexa_sum => new string ' (hex_image(Message_Note_On)),
					  long_sum => new string ' (long'image(Message_Note_On)));
				    begin
				       --Put_Line("tatata 1.4.1.0");
				       --print(printed_message.all);
				       
				       Step_Sequencer.box.receive(printed_message);
				       --Put_Line("messages sended to message box");
				       
				    end;
				    --Put_Line("tatata 1.4.2");
				    declare				       
				       printed_message : constant printed_message_access := new printed_message_type '
					 (source => new string ' (Positive'image(Positive(Step_Sequencer.plugin.id))),
					  destination => new string ' (Positive'Image(Positive(Step_Sequencer.plugin.Device_Id))),
					  data_type => new string ' (control_type'image(control_of(Message_Note_Off))),
					  channel => new string ' (channel_type'image(channel_of(Message_Note_Off))),
					  data1 => new string ' (interfaces.c.long'image(data1(Message_Note_Off))),
					  data2 => new string ' (interfaces.c.long'image(data2(Message_Note_Off))),
					  hour => new string ' (formatting.image(date+length, true)),
					  hexa_sum => new string ' (hex_image(Message_Note_Off)),
					  long_sum => new string ' (long'image(Message_Note_Off)));
				    begin
				       
				       --print(printed_message.all);
				       
				       Step_Sequencer.box.receive(printed_message);
				       --Put_Line("messages sended to message box");
				       
				    end;
				    --Put_Line("tatata 1.4.3");
				 end if;
				 --Put_Line("tatata 1.5");				       
				 Step_Sequencer.Event_Process.Receive(Step_Sequencer.plugin.Device_Id, date, Message_Note_On, 0.0, tempo);
				 --Put_Line("tatata 1.6");
				 Step_Sequencer.Event_Process.Receive(Step_Sequencer.plugin.Device_Id, Date, Message_Note_Off, length, tempo);
				 --Put_Line("tatata 1.7");
			      end;
			      
			   end if;
			end if;			
		     end if;
		     
		  end loop;
		  start_time := start_time + Quantum;
	       else
		  start_time := start_time + Quantum;
		  --Put_Line("tatata 3");		     		     
	       end if;
	       -- end if;
	       --   end if;
	       --Put_Line("step_seq started ::= MIMI 0.1.275");
	    end select;	    
	    Next(bar_beat, Options.Track_length, signature.number, signature.unit);		  
	    
	    --Put_Line("step_seq started ::= MIMI 0.1.276");
	 end loop;
      end loop;
   end Step_Sequencer_Process;
   
end Libsens.Processing.Step_Sequencer;
