
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--                                                                                                                                                                         --
--                                                                      ---------------------------                                                                        --
--                                                                      --       El-Sofware      --                                                                        --
--                                                                      ---------------------------                                                                        --
--                                                                                                                                                                         --
--                                                                                present                                                                                  --
--                                                                                                                                                                         --
--                                                                            ---------------                                                                              --
--                                                                            --  MidiSurf --                                                                              --
--                                                                            ---------------                                                                              --
--                                                                                                                                                                         --
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--                                                                                                                                                                         --
-- Auteur      : Manuel De Girardi                                                                                                                                         --
-- Date        : 25/11/2010                                                                                                                                                --
-- Description : Surface de contrôle pour instrument MIDI                                                                                                                  --
--                                                                                                                                                                         --
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------



--with PragmARC.Math.Functions;

with Text_Io;                           use Text_Io;
with Interfaces.C;                      use Interfaces.C;

package body Libsens.Rem_Common is


   package Real_Io is new Text_Io.Float_Io(PragmARC.REM_NN_Wrapper.Real);
   use Real_Io;
   --package Real_Math is new PragmARC.Math.Functions (Supplied_Real => PragmARC.REM_NN_Wrapper.Real);
   --use Real_Math;

   function To_Bbyte(Byte : in T_Byte) return T_Bbyte is
      Bbyte : T_Bbyte;
      Tmp   : T_Byte   := Byte;
   begin
      for I in reverse Bbyte'Range loop
         Bbyte (I) := Boolean'Val (Tmp rem 2);
         Tmp := Tmp / 2;
      end loop;
      return Bbyte;
   end To_Bbyte;
   function To_byte(Bbyte : in T_Bbyte) return T_Byte is
      Byte : T_Byte := 0;
   begin
      for I in reverse Bbyte'Range loop
         Byte := Byte + (boolean'Pos(Bbyte(I))*(2**(7-I)));
      end loop;
      return Byte;
   end To_Byte;
   function Chord_To_Register(Chord : T_Chord) return T_Register is
      Register : T_Register := (others => 0.0);
      Bbyte : T_Bbyte := (others => False);
   begin
      --Put_Line("fafa 0.0");
      for I in 0..Chord'Last-1 loop
	 --Put_Line("fafa 0.1");
         Bbyte := To_Bbyte(Integer(Chord(I+1).Key));
         for J in 1..7 loop
	    --Put_Line("fafa 0.2");
            Register(14*I+J) := Real(boolean'pos(Bbyte(J)));
         end loop;
	 --Put_Line("fafa 0.4");
         Bbyte := (others => False);
	 
         Bbyte := To_Bbyte(Integer(Chord(I+1).Vel));
	 --Put_Line("fafa 0.5");
         for J in 1..7 loop
	    --Put_Line("fafa 0.6");
            Register(14*I+J+7) := Real(boolean'pos(Bbyte(J)));
         end loop;
         Bbyte := (others => False);
	 --Put_Line("fafa 0.7");
      end loop;
      --Put_Line("fafa 0.8");
      return Register;
   end Chord_To_Register;

   function Register_To_Chord(Register : T_Register) return T_Chord is
      Chord : T_Chord(1..3) := (others => new T_note ' (64, 64, 64));
      Bbyte : T_Bbyte := (others => False);
      Byte : T_Byte := 0;
   begin
      for I in 0..Chord'Length-1 loop
         for J in 1..7 loop
            Bbyte(J) := Boolean'Val(Integer(Register(I*14+J)));
         end loop;
         Byte := To_Byte(Bbyte);
         if Byte < 128 then
            Chord(I+1).Key := Long(Byte);
         end if;
         Byte := 0;
         Bbyte := (others => False);
         for J in 1..7 loop
            Bbyte(J) := Boolean'Val(Integer(Register(I*14+J+7)));
         end loop;
         Byte := To_Byte(Bbyte);
         if Byte < 128 then
            Chord(I+1).vel := Long(Byte);
         end if;
         Byte := 0;
         Bbyte := (others => False);
      end loop;
      return Chord;
   end Register_To_Chord;




   function REM_NN_Expl(Network : String;Prob : string) return T_Register is

      procedure Get_Input (Pattern : in Positive;
                           Input : out Node_Set;
                           Desired : out Node_Set) is
         File : Register_Io.File_Type;
      begin
         Register_Io.Open(File, Register_Io.In_File, Prob);
         Register_Io.Read(File, T_Register(Input), Register_Io.Count(Pattern));
         Register_Io.Close(File);
         Desired := (others => 0.0);
      end Get_Input;


      package Harmonie_REM_NN_Expl is new REM_NN
        (Num_Input_Nodes => T_Register'length,
         Num_Hidden_Nodes => (T_Register'Length/7),
         Num_Output_Nodes => T_Register'length,
         Input_To_Output_Connections => True,
         New_Random_Weights => False,
         Weight_File_Name => network,
         Num_Patterns => 1,
         Get_Input => Get_Input);

      Response : Harmonie_REM_NN_Expl.Output_Set;

   begin
      Harmonie_REM_NN_Expl.Respond (1, Response);
      return T_Register(Response);
   end REM_NN_Expl;
end Libsens.Rem_Common;
