
package Libsens.Virtual.Plugins is      
   
   
   --type Abstract_Plugin_Class is abstract tagged limited null record;
   type Abstract_Plugin_Class is abstract tagged null record;
   
   procedure Print(Filename : in String; Plug : in Abstract_Plugin_Class) is abstract;   

   
   
   
   type Plugin_Class(Class : Plugin_Enum) is new Abstract_Plugin_Class with
      record
	 Name      : access String := new String ' ("");
	 Id        : Plugin_Num := 1;	 	 
	 Device_ID : Device_Num := 1;
	 Ch_ID     : Channel_Num := 1;
	 
	 Form_ID   : Form_Index_Type := 1;
	 Cat_ID    : Category_Index_Type := 1;
	 
	 Opened    : Boolean := False;
	 Printed   : Boolean := False;
	 Mutted    : Boolean := False;	 
      end record;
   
   procedure Initialize (Plug      : in out Plugin_Class;
			 Id        : in Plugin_num;
			 Device    : in Device_Num;
			 Ch        : in Channel_Num;
			 Form      : in Form_Index_Type;
			 Cat       : in Category_Index_Type);
   
   procedure Set_Id(Plug       : in out Plugin_Class;
		    Id        : in Plugin_Num);
   
   function Get_Id(Plug        : in Plugin_Class) return Plugin_Num;
   
   procedure Set_Device(Plug       : in out Plugin_Class;
			Device    : in Device_Num);
   
   function Get_Device(Plug        : in Plugin_Class) return Device_Num;
   
   procedure Set_Channel(Plug       : in out Plugin_Class;
			 Ch        : in Channel_Num);
   
   function Get_Channel(Plug        : in Plugin_Class) return Channel_Num;
   
   procedure Set_Form(Plug       : in out Plugin_Class;
		      Form      : in Form_Index_Type);
   
   function Get_Form(Plug        : in Plugin_Class) return Form_Index_Type;
   
   
   procedure Set_Category(Plug       : in out Plugin_Class;
			  Cat       : in Category_Index_Type);
   
   function Get_Category(Plug        : in Plugin_Class) return Category_Index_Type;
   
   procedure Print (Filename : in String; Plug : in Plugin_Class);      
   
end Libsens.Virtual.Plugins;
